/*
 * $Id: ApplicationTask.java 110785 2010-09-30 22:01:39Z clinio $
 */

package csbase.client.applications;

import javax.swing.ImageIcon;

import csbase.client.desktop.LocalTask;
import csbase.client.desktop.Task;

/**
 * Tarefa de execuo de uma aplicao
 * 
 * @author Tecgraf/PUC-Rio
 * @param <R> tipo de retorno da task
 */
abstract public class ApplicationTask<R> extends LocalTask<R> {

  /**
   * Aplicao.
   */
  final private Application application;

  /**
   * Mensagem
   */
  private String message;

  /**
   * Ajuste da mensagem
   * 
   * @param message mensagem
   */
  public final void setMessage(String message) {
    this.message = message;
  }

  /**
   * Ajuste da imagem.
   * 
   * @param image imagem
   */
  public final void setImage(ImageIcon image) {
    this.image = image;
  }

  /**
   * Imagem associada
   */
  private ImageIcon image;

  /**
   * Tratador especfico da aplicao (usado em todos os momentos).
   * 
   * @param exception a excepo detectada.
   */
  @Override
  protected void handleError(final Exception exception) {
    if (!application.handleError(exception)) {
      super.handleError(exception);
    }
  }

  /**
   * Consulta  aplicao origem.
   * 
   * @return a aplicao
   */
  final public Application getApplication() {
    return application;
  }

  /**
   * Execuo da tarefa.
   * 
   * @return true se a tarefa foi executada at o final (h um resultado) false
   *         se a ocorrncia de um erro impediu a execuo da tarefa (no h
   *         resultado associado)
   * @see Task#execute(java.awt.Window, String, String, int, int, boolean,
   *      boolean, ImageIcon)
   */
  public final boolean execute() {
    final ApplicationFrame frame = application.getApplicationFrame();
    return execute(frame, application.getName(), message);
  }

  /**
   * Execuo da tarefa.
   * 
   * @return true se a tarefa foi executada at o final (h um resultado) false
   *         se a ocorrncia de um erro impediu a execuo da tarefa (no h
   *         resultado associado)
   * @see Task#execute(java.awt.Window, String, String, int, int, boolean,
   *      boolean, ImageIcon)
   */
  public final boolean executeTask() {
    return execute(application.getApplicationFrame(), application.getName(),
      message, Task.DEFAULT_CANCEL_DELAY, Task.CANCEL_BUTTON, true, true, image);
  }

  /**
   * Construtor padro.
   * 
   * @param app a aplicao.
   */
  public ApplicationTask(final Application app) {
    application = app;
    setMessage(app.getName() + "...");
  }

  /**
   * Construtor padro.
   * 
   * @param app a aplicao.
   * @param msg uma mensagem de espera.
   */
  public ApplicationTask(final Application app, final String msg) {
    this(app);
    setMessage(msg);
  }

  /**
   * Construtor padro.
   * 
   * @param app a aplicao.
   * @param msg uma mensagem de espera.
   * @param img imagem do dilogo de espera.
   */
  public ApplicationTask(final Application app, final String msg,
    final ImageIcon img) {
    this(app);
    setMessage(msg);
    setImage(img);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected abstract void performTask() throws Exception;
}
