package csbase.client.applications.algorithmsmanager.actions;

import java.awt.event.ActionEvent;

import javax.swing.ImageIcon;

import csbase.client.applications.AbstractSimpleApplicationAction;
import csbase.client.applications.algorithmsmanager.AlgorithmsManager;

/**
 * Representa uma ao genrica para a aplicao de gerncia de algoritmos.
 * 
 * @author Tecgraf
 */
public abstract class AlgorithmsManagerAction extends
  AbstractSimpleApplicationAction<AlgorithmsManager> {

  /**
   * Constri uma ao da aplicao de gerncia de algoritmos.
   * 
   * @param application referncia para a aplicao
   */
  protected AlgorithmsManagerAction(AlgorithmsManager application) {
    super(application);
  }

  /**
   * Constri uma ao da aplicao de gerncia de algoritmos.
   * 
   * @param application referncia para a aplicao
   * @param icon imagem da ao
   */
  protected AlgorithmsManagerAction(AlgorithmsManager application,
    ImageIcon icon) {
    super(application, icon);
  }

  /**
   * (non-Javadoc)
   * 
   * @see csbase.client.applications.AbstractSimpleApplicationAction#handleActionPerformed(java.awt.event.ActionEvent)
   */
  @Override
  protected abstract void handleActionPerformed(ActionEvent ae)
    throws Exception;

}
