package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.applications.algorithmsmanager.actions.CategoryManagementAction;

/**
 * Classe que define o painel para a funcionalidade de gerenciamento de
 * categorias, na aplicao Gerenciador de Algoritmos.
 * 
 * Esse painel possui a estrutura comum definida na classe
 * <code> CommonManagementPanel </code>, e cria o painel de seleo de dados e o
 * painel de edio do dado selecionado.
 * 
 */
public class CategoryManagementPanel extends CommonManagementPanel {

  /**
   * Constri o painel.
   * 
   * @param action ao que criou esse painel
   */
  public CategoryManagementPanel(CategoryManagementAction action) {
    super(action);
  }

  @Override
  protected CommonEditTabbedPanel buildEditPanel() {
    CommonEditTabbedPanel editPanel = new CategoryEditDataPanel(
      getManagementAction());
    return editPanel;
  }

  @Override
  protected CommonSelectionPanel buildSelectionPanel() {
    CommonSelectionPanel selectionPanel = new CategorySelectionPanel(
      getCategoryManagementAction());
    return selectionPanel;
  }

  @Override
  public CategorySelectionPanel getSelectionPanel() {
    if (super.getSelectionPanel() == null)
      return null;
    return (CategorySelectionPanel) super.getSelectionPanel();
  }

  /**
   * Obtm a ao de gerenciamento de categorias.
   * 
   * @return a ao de gerenciamento de categorias
   */
  protected CategoryManagementAction getCategoryManagementAction() {
    return (CategoryManagementAction) getManagementAction();
  }
}
