/*
 * $Id$
 */

package csbase.client.applications.algorithmsmanager.dialogs;

import javax.swing.JTextField;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.util.ClientUtilities;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;

/**
 * Classe abstrata que implementa um dilogo de verso.
 * 
 */
public abstract class VersionDialog {
  /** Dilogo */
  protected DesktopComponentDialog dialog;

  /** Nmero da verso */
  protected JTextField majorField;

  /** Nmero da reviso */
  protected JTextField minorField;

  /** Nmero da correo */
  protected JTextField patchField;

  /** Informaes sobre o algoritmo ao qual pertence a verso */
  protected AlgorithmInfo algoInfo;

  /** Ttulo do dilogo */
  protected String dialogTitle;

  /**
   * Cria um dilogo de verso.
   * 
   * @param algoInfo informaes sobre o algoritmo dentro do qual a verso ser
   *        criada.
   */
  protected VersionDialog(AlgorithmInfo algoInfo) {
    this.algoInfo = algoInfo;
  }

  /**
   * Obtm os nmeros da verso a partir dos campos editados.
   * 
   * @return array com os nmeros ou null em caso de erro
   */
  protected int[] getVersionNumbers() {
    int major =
      validateVersionNumberField(majorField,
        LNG.get("algomanager.error.version_part"));
    if (major == -1) {
      return null;
    }
    int minor =
      validateVersionNumberField(minorField,
        LNG.get("algomanager.error.version_part"));
    if (minor == -1) {
      return null;
    }
    int patch =
      validateVersionNumberField(patchField,
        LNG.get("algomanager.error.version_part"));
    if (patch == -1) {
      return null;
    }
    Object id = AlgorithmVersionInfo.getIdFor(major, minor, patch);
    if (algoInfo.getVersionInfo(id) != null) {
      ClientUtilities.showErrorByTextField(dialog,
        LNG.get("algomanager.error.dup_version"), null, majorField);
      return null;
    }
    return new int[] { major, minor, patch };
  }

  /**
   * Valida um campo de texto numrico para identificao de verso (major,
   * minor, patch).
   * 
   * @param field referncia para o campo de texto
   * @param errMsg mensagem de erro para o campo correspondente
   * 
   * @return valor numrico correspondente ou -1 em caso de erro
   */
  private int validateVersionNumberField(JTextField field, String errMsg) {
    try {
      int value = Integer.parseInt(field.getText());
      if ((value >= 0) && (value <= 999)) {
        return value;
      }
    }
    catch (NumberFormatException e) {
    }
    ClientUtilities.showErrorByTextField(dialog, errMsg, null, field);
    return -1;
  }
}
