/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor;

import java.awt.Component;

import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 * Trata o evento de seleo de abas em um {@link JTabbedPane}.<br>
 * Quando uma nova aba  selecionada, a aba anterior serhavisada que perdeu a
 * seleo e a nova aba ser informada de que ganhou a seleo. As abas que
 * desejam obter a informao de seleo devem implementar
 * {@link ISelectionListenerTab}.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class JTabbedPaneSelectionListener implements ChangeListener {

  /**
   * Componente selecionado.
   */
  private Component selected;

  /**
   * {@inheritDoc}
   */
  @Override
  public void stateChanged(ChangeEvent e) {
    if (!JTabbedPane.class.isAssignableFrom(e.getSource().getClass())) {
      throw new IllegalArgumentException(this.getClass().getSimpleName()
        + " should only be used to handle JTabbedPane tab selection.");
    }

    JTabbedPane tabbedPane = JTabbedPane.class.cast(e.getSource());
    Component newSelected = tabbedPane.getSelectedComponent();
    if ((null == newSelected && null == newSelected)
      || (null != newSelected && newSelected.equals(selected))) {
      return;
    }

    if (null != selected) {
      if (ISelectionListenerTab.class.isAssignableFrom(selected.getClass())) {
        ISelectionListenerTab.class.cast(selected).onSelectionChanged(false);
      }
    }

    this.selected = newSelected;
    if (null != newSelected) {
      if (ISelectionListenerTab.class.isAssignableFrom(newSelected.getClass())) {
        ISelectionListenerTab.class.cast(newSelected).onSelectionChanged(true);
      }
    }
  }
}