package csbase.client.applications.commandsmonitor.table.column;

import java.util.Locale;

import csbase.logic.CommandInfo;
import csbase.logic.applicationservice.ApplicationRegistry;

/**
 * Coluna contendo o nome do projedo no qual o comando est persistido. <br>
 *
 * @author Tecgraf / PUC-Rio
 */
public class ProjectColumn extends AbstractCommandsTableColumn {

    /**
     * Construtor.
     *
     * @param id Identificador da coluna.
     * @param appRegistry registro da aplicao que ser utilizado para se obter o
     *        nome da coluna de acordo com o {@link Locale}.
     */
  public ProjectColumn(String id, ApplicationRegistry appRegistry) {
    super(String.class, id, appRegistry);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(CommandInfo cmd) {
    String projectId = cmd.getProjectId().toString();
    return projectId.replaceAll("^[/\\\\]?[^/\\\\]+[/\\\\](.*)$", "$1");
  }
}

