/*
 * $Id: OpenLogAction.java 72790 2008-02-15 20:05:47Z clinio $
 */
package csbase.client.applications.csvviewer.actions;

import java.util.ArrayList;
import java.util.Collection;

import javax.swing.JComponent;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.csvviewer.CSVViewer;
import csbase.client.util.filechooser.ClientLocalFileChooserUtil;
import csbase.logic.ClientFile;

/**
 * Pede para a aplicao que detm o painel de controle por um novo arquivo de
 * csv e o abre no painel de csv.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class OpenLocalCSVAction extends AbstractCSVAction {

  /**
   * Construtor
   * 
   * @param application o aplicativo dono dessa ao.
   */
  public OpenLocalCSVAction(CSVViewer application) {
    super(application, ApplicationImages.ICON_OPEN_LOCAL_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(JComponent component) {
    Collection<String> fileTypes = new ArrayList<String>();
    CSVViewer application = getApplication();
    ApplicationFrame applicationFrame = application.getApplicationFrame();
    final String title = applicationFrame.getTitle();
    fileTypes.addAll(application.getFileTypes());
    ClientFile file =
      ClientLocalFileChooserUtil.browseSingleFileInOpenMode(applicationFrame,
        fileTypes, title, true, null);
    if (file == null) {
      return;
    }
    application.openFile(file);
  }
}
