package csbase.client.applications.desktoplauncher.actions;

import csbase.client.applications.AbstractSimpleApplicationAction;
import csbase.client.applications.desktoplauncher.DesktopLauncher;
import csbase.client.applications.desktoplauncher.DesktopLauncherEventHandler;

/**
 * Ao bsica do programa
 * 
 * @author Tecgraf/PUC-Rio
 */
abstract class DesktopLauncherAction extends
  AbstractSimpleApplicationAction<DesktopLauncher> {

  /**
   * Construtor
   * 
   * @param application aplicao.
   */
  public DesktopLauncherAction(DesktopLauncher application) {
    super(application);
  }

  /**
   * Consulta o tratador de eventos da aplicao.
   * 
   * @return o tratador
   */
  final public DesktopLauncherEventHandler getEventHandler() {
    final DesktopLauncher application = getApplication();
    final DesktopLauncherEventHandler eventHandler =
      application.getEventHandler();
    return eventHandler;
  }
}
