/*
 * $Id:$
 */

package csbase.client.applications.diskmonitor.actions;

import javax.swing.Action;
import javax.swing.JComponent;

import csbase.client.applications.diskmonitor.DiskMonitor;
import csbase.client.applications.diskmonitor.actions.core.DiskMonitorAction;
import csbase.client.remote.srvproxies.DiskUsageProxy;
import csbase.remote.DiskUsageServiceInterface;

/**
 * Ao de refresh imediato.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class DiskMonitorChangeAreaAction extends DiskMonitorAction {

  /**
   * Id relativo  mudana
   */
  final private String id;

  /**
   * Construtor
   * 
   * @param application aplicao.
   * @param id identificador da rea no {@link DiskUsageServiceInterface}.
   */
  public DiskMonitorChangeAreaAction(DiskMonitor application, final String id) {
    super(application);
    final String areaName = DiskUsageProxy.translateAreaId(id);
    putValue(Action.NAME, areaName);
    this.id = id;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(JComponent cmp) {
    final DiskMonitor application = getApplication();
    application.setCurrentAreaId(id);
    application.refresh();
  }

}
