package csbase.client.applications.fileexchanger.actions;

import javax.swing.Action;

import csbase.client.applications.fileexchanger.FileExchanger;
import csbase.client.applications.fileexchanger.actions.core.FileExchangerAction;
import csbase.client.applications.fileexchanger.logic.BlockSize;
import csbase.client.applications.fileexchanger.logic.FileExchangerConfiguration;

/**
 * Ao para definir o modo de transmisso.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class BlockSizeAction extends FileExchangerAction {

  /** Modo de ajuste. */
  final private BlockSize blockSize;

  /**
   * Construtor.
   * 
   * @param fileExchanger aplicao
   * @param blockSize modo a ser ajustado.
   */
  public BlockSizeAction(FileExchanger fileExchanger, BlockSize blockSize) {
    super(fileExchanger);
    this.blockSize = blockSize;
    String sufix = String.format(" - %skb", blockSize.getSizeKb());
    putValue(Action.NAME, blockSize.getName() + sufix);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone() {
    FileExchangerConfiguration configuration =
      getApplication().getConfiguration();
    configuration.setBlockSize(blockSize);
  }
}
