package csbase.client.applications.fileexchanger.logic;

import java.io.File;

import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;

/**
 * Operao de Importao.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ExchangeImport extends Exchange {

  /**
   * {@inheritDoc}
   */
  @Override
  protected ExchangeImportThread createThread() {
    return new ExchangeImportThread(this);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public String toString() {
    final ClientProjectFile remoteFile = getRemoteFile();
    final File localFile = getLocalFile();
    if (remoteFile != null) {
      return localFile.getAbsolutePath() + " \u2192 " + remoteFile.getName();
    }
    return "";
  }
  
  /**
   * Construtor
   * 
   * @param transferMode modo de transferncia
   * @param blockSize tam. do bloco.
   * @param localFile arquivo local
   * @param remoteFile arquivo remoto
   * @param remoteDir diretrio remoto
   * @param project projeto do arquivo remoto 
   */
  public ExchangeImport(final ExchangeMode transferMode,
    final BlockSize blockSize, final File localFile,
    final ClientProjectFile remoteFile, final ClientProjectFile remoteDir,
    final CommonClientProject project) {
    super(ExchangeType.IMPORT, transferMode, blockSize, localFile, remoteFile,
      remoteDir, getLength(localFile), project);
  }

  /**
   * Obtm o tamanho do arquivo ou do diretrio.
   * 
   * @param file arquivo.
   * @return Tamanho do arquivo. TODO Colocar esse mtodo no javautils.
   */
  public static long getLength(File file) {
    long lenght = 0;
    if (file.isDirectory()) {
      // Soma o tamanho do diretrio.
      lenght += file.length();
      for (File child : file.listFiles()) {
        // Soma o tamanho do arquivo.
        lenght += getLength(child);
      }
    }
    else {
      lenght = file.length();
    }
    return lenght;
  }
  
}
