package csbase.client.applications.fileexchanger.logic;

import csbase.client.applications.fileexchanger.FileExchangerUI;

/**
 * Modo de transferncia
 * 
 * @author Tecgraf/PUC-Rio
 */
public enum ExchangeMode {
  /**
   * Transmisso por stream
   */
  STREAM,

  /**
   * Transmisso por operao direta.
   */
  OPERATION;

  /**
   * Consulta o texto da descrio.
   * 
   * @return o texto
   */
  public String getName() {
    final String tag = "ExchangeMode." + toString() + ".name";
    return FileExchangerUI.getString(tag);
  }
}
