package csbase.client.applications.fileexchanger.panels.tablepanel;

import java.awt.Color;
import java.awt.Component;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;

import tecgraf.javautils.core.lng.FormatUtils;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.fileexchanger.FileExchangerUI;
import csbase.client.applications.fileexchanger.logic.BlockSize;
import csbase.client.applications.fileexchanger.logic.Exchange;
import csbase.client.applications.fileexchanger.logic.ExchangeMode;
import csbase.client.applications.fileexchanger.logic.ExchangeState;
import csbase.client.applications.fileexchanger.logic.ExchangeType;

/**
 * Renderer de tipo
 * 
 * @author Tecgraf/PUC-Rio
 */
public class TableListRenderer extends DefaultTableCellRenderer {

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getTableCellRendererComponent(JTable table, Object value,
    boolean isSelected, boolean hasFocus, int row, int column) {
    JLabel label =
      (JLabel) super.getTableCellRendererComponent(table, value, isSelected,
        hasFocus, row, column);

    label.setIcon(null);
    label.setToolTipText(null);
    label.setText(null);
    label.setForeground(Color.BLACK);
    label.setHorizontalAlignment(SwingConstants.CENTER);
    label.setVerticalAlignment(SwingConstants.CENTER);

    if (row < 0) {
      return label;
    }

    if (column == 0) {
      final ExchangeType type = (ExchangeType) value;
      final ImageIcon exIcon = ApplicationImages.ICON_EXPORT_16;
      final ImageIcon imIcon = ApplicationImages.ICON_IMPORT_16;
      final ImageIcon icon = (type == ExchangeType.IMPORT ? imIcon : exIcon);
      label.setIcon(icon);
      label.setToolTipText(type.getDescription());
      return label;
    }
    if (column == 1) {
      Exchange exchange = (Exchange) value;
      boolean isDirectory = false;
      if (exchange.getType() == ExchangeType.IMPORT) {
        if (exchange.getLocalFile().isDirectory()) {
          isDirectory = true;
        }
      }
      else if (exchange.getType() == ExchangeType.EXPORT) {
        if (exchange.getRemoteFile().isDirectory()) {
          isDirectory = true;
        }
      }
      ImageIcon icon = null;
      if (isDirectory) {
        icon = ApplicationImages.ICON_FOLDER_16;
        label.setToolTipText(FileExchangerUI
          .getString("TableListRenderer.directory"));
      }
      else {
        icon = ApplicationImages.ICON_FILE_16;
        label.setToolTipText(FileExchangerUI
          .getString("TableListRenderer.file"));
      }
      label.setIcon(icon);
      return label;
    }
    else if (column == 2) {
      final Exchange exchange = (Exchange) value;
      final ExchangeState state = exchange.getState();
      final Icon image = state.getImage();
      String toolTipText = state.getDescription();
      if (state == ExchangeState.ERROR && exchange.getException() != null) {
        toolTipText += ": " + exchange.getException().getMessage();
      }
      label.setToolTipText(toolTipText);
      label.setIcon(image);
      return label;
    }
    else if (column == 3) {
      final int n = (Integer) value;
      if (n <= 0.0) {
        label.setText("-");
        return label;
      }
      final JProgressBar bar = new JProgressBar();
      bar.setValue(n);
      bar.setStringPainted(true);
      bar.setString(n + "%");
      return bar;
    }
    else if (column == 4) {
      final String path = (String) value;
      label.setText(path);
      label.setHorizontalAlignment(SwingConstants.LEFT);
      return label;
    }
    else if (column == 5) {
      final String path = (String) value;
      label.setText(path);
      label.setHorizontalAlignment(SwingConstants.LEFT);
      return label;
    }
    else if (column == 6) {
      final long remaining = (Long) value;
      label.setText(FileExchangerUI.formatLongTime(remaining));
      label.setHorizontalAlignment(SwingConstants.RIGHT);
      return label;
    }
    else if (column == 7) {
      final long elapsed = (Long) value;
      label.setText(FileExchangerUI.formatLongTime(elapsed));
      label.setHorizontalAlignment(SwingConstants.RIGHT);
      return label;
    }
    else if (column == 8) {
      final double rate = (Double) value;
      if (rate <= 0.0) {
        label.setText("-");
      }
      else {
        label.setText(String.format("%.3f", rate) + " Mb/s");
      }
      label.setHorizontalAlignment(SwingConstants.RIGHT);
      return label;
    }
    else if (column == 9) {
      final double rate = (Double) value;
      if (rate <= 0.0) {
        label.setText("-");
      }
      else {
        label.setText(String.format("%.3f", rate) + " Mb/s");
      }
      label.setHorizontalAlignment(SwingConstants.RIGHT);
      return label;
    }
    else if (column == 10) {
      final long size = (Long) value;
      if (size <= 0.0) {
        label.setText("-");
      }
      else {
        label.setText(FormatUtils.formatSize(size, 2));
        label.setHorizontalAlignment(SwingConstants.RIGHT);
      }
      return label;
    }
    else if (column == 11) {
      final ExchangeMode transferMode = (ExchangeMode) value;
      label.setText(transferMode.getName());
      label.setHorizontalAlignment(SwingConstants.CENTER);
      return label;
    }
    else if (column == 12) {
      final BlockSize blockSize = (BlockSize) value;
      label.setText(blockSize.getSizeKb() + " KB");
      label.setHorizontalAlignment(SwingConstants.RIGHT);
      return label;
    }
    else {
      final Exchange exchange = (Exchange) value;
      label.setText(exchange.toString());
      return label;
    }
  }
}
