package csbase.client.applications.filetransfer;

import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectTree;
import csbase.client.remote.ClientProjectObserver;
import csbase.logic.CommonClientProject;
import csbase.logic.UserProjectInfo;

/**
 * Tarefa remota que l o projeto.
 * 
 * @author Tecgraf
 */
class ReadProjectTask extends RemoteTask<CommonClientProject> {

  /** A rvore de diretrios do projeto. */
  private ProjectTree projectTree;

  /** Combo de Projeto. */
  private ProjectComboBox projectCombo;

  /** Projeto. */
  private CommonClientProject project;

  /**
   * Construtor.
   * 
   * @param projectTree rvore de diretrios do projeto.
   * @param projectCombo combo de projetos.
   * @param project projeto.
   */
  ReadProjectTask(ProjectTree projectTree, ProjectComboBox projectCombo,
    CommonClientProject project) {
    this.project = project;
    this.projectTree = projectTree;
    this.projectCombo = projectCombo;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void performTask() throws Exception {
    // Desinstalando o observador do projeto selecionado anteriormente
    if ((project != null)) {
      project.uninstallObserver();
    }

    // Abrindo o projeto correspondente ao item selecionado da combo.
    UserProjectInfo prj = (UserProjectInfo) projectCombo.getSelectedItem();
    CommonClientProject newProject =
      CommonClientProject.openProject(prj.getProjectId(), true);
    setResult(newProject);
    // Instalando o observador desse projeto.
    newProject.installObserver(new ClientProjectObserver(newProject));
    projectTree.setProject(newProject);
  }
}