/*
 * $Id: RefreshLocalAction.java 88758 2009-02-27 21:57:35Z clinio $
 */

package csbase.client.applications.filetransferclient.actions;

import javax.swing.ImageIcon;
import javax.swing.JComponent;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.actions.core.FileTransferClientAction;
import csbase.client.applications.filetransferclient.panels.localpanel.FileTransferClientLocalPanel;

/**
 * Ao de refrescamento do painel de arquivos locais.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class RefreshLocalAction extends FileTransferClientAction {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(final JComponent component) {
    final FileTransferClient app = getApplication();
    final FileTransferClientLocalPanel localPanel = app.getLocalPanel();
    localPanel.refresh();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getStandardImageIcon() {
    return ApplicationImages.ICON_REFRESH_16;
  }

  /**
   * Construtor
   * 
   * @param application aplicao
   */
  public RefreshLocalAction(final FileTransferClient application) {
    super(application);
  }
}
