package csbase.client.applications.filetransferclient.actions;

import javax.swing.ImageIcon;
import javax.swing.JComponent;

import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.actions.core.FileTransferClientAction;
import csbase.client.applications.filetransferclient.panels.localpanel.FileTransferClientLocalPanel;

/**
 * @author Tecgraf/PUC-Rio
 */
public class ToggleDotFilterLocalAction extends FileTransferClientAction {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(JComponent component) {
    final FileTransferClient application = getApplication();
    final FileTransferClientLocalPanel localPanel = application.getLocalPanel();
    final boolean dotFiltered = localPanel.isDotFiltered();
    localPanel.setDotFiltered(!dotFiltered);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getStandardImageIcon() {
    return null;
  }

  /**
   * Construtor
   * 
   * @param application a aplicao.
   */
  public ToggleDotFilterLocalAction(final FileTransferClient application) {
    super(application);
  }
}
