/*
 * $Id: FileTransferClientPanel.java 88652 2009-02-20 04:45:52Z clinio $
 */
package csbase.client.applications.filetransferclient.panels.core;

import javax.swing.JPanel;

import csbase.client.applications.filetransferclient.FileTransferClient;

/**
 * Painel da aplicao
 * 
 * @author Tecgraf/PUC-Rio
 */
public class FileTransferClientPanel extends JPanel {

  /**
   * O programa
   */
  final private FileTransferClient application;

  /**
   * Consulta uma string internacionalizada.
   * 
   * @param tag tag
   * @return o texto
   */
  final public String getString(final String tag) {
    final String prefix = this.getClass().getSimpleName();
    return application.getString(prefix + "." + tag);
  }

  /**
   * Consulta ao programa
   * 
   * @return o programa
   */
  final public FileTransferClient getApplication() {
    return application;
  }

  /**
   * Construtor.
   * 
   * @param application aplicao
   */
  public FileTransferClientPanel(final FileTransferClient application) {
    this.application = application;
  }
}
