/*
 * $Id:$
 */

package csbase.client.applications.filetransferclient.panels.localpanel;

import java.util.ArrayList;

import javax.swing.table.AbstractTableModel;

import csbase.logic.ClientProjectFile;

/**
 * Modelo de arquivos locais.
 * 
 * @author Tecgraf/PUC-Rio
 */
class LocalTableModel extends AbstractTableModel {

  /**
   * Lista de arquivos.
   */
  private ArrayList<ClientProjectFile> fileList;

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<?> getColumnClass(int col) {
    if (col == 0) {
      return ClientProjectFile.class;
    }
    else if (col == 1) {
      return String.class;
    }
    else if (col == 2) {
      return Long.class;
    }
    return null;
  }

  /**
   * Aplicao (usada apnes para internacionalizao.
   */
  final private String[] columnNames;

  /**
   * {@inheritDoc}
   */
  @Override
  final public int getRowCount() {
    if (fileList == null) {
      return 0;
    }
    return fileList.size();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public int getColumnCount() {
    return columnNames.length;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public String getColumnName(final int col) {
    return columnNames[col];
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public Object getValueAt(final int row, final int col) {
    final ClientProjectFile file = fileList.get(row);
    if (col == 0) {
      return file;
    }
    else if (col == 1) {
      return file.getName();
    }
    else if (col == 2) {
      if (file.isDirectory()) {
        return -1L;
      }
      return (long) file.size();
    }
    return null;
  }

  /**
   * Ajusta a lista de arquivos.
   * 
   * @param list a lista
   */
  final public void setFileList(final ArrayList<ClientProjectFile> list) {
    fileList = list;
    fireTableDataChanged();
  }

  /**
   * @return a lista
   */
  final public ArrayList<ClientProjectFile> getFileList() {
    return fileList;
  }

  /**
   * @param columnNames nomes das colunas.
   */
  public LocalTableModel(final String[] columnNames) {
    this.columnNames = columnNames;
  }
}
