package csbase.client.applications.filetransferclient.panels.queuepanel;

import java.awt.Color;
import java.awt.Component;
import java.util.Date;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

import tecgraf.javautils.core.lng.FormatUtils;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applications.filetransferclient.FileTransferClientUI;
import csbase.client.util.DateTranslator;
import csbase.logic.User;
import csbase.logic.filetransferservice.FileTransferRequestStatus;
import csbase.logic.filetransferservice.FileTransferRequestType;

/**
 * Renderizador da tabela de requisies
 * 
 * @author Tecgraf/PUC-Rio
 */
class QueueRenderer implements TableCellRenderer {

  /**
   * Renderer default.
   */
  public static final DefaultTableCellRenderer DEFAULT_RENDERER =
    new DefaultTableCellRenderer();

  /**
   * Formatador de datas.
   * 
   * @param date data.
   * @return texto
   */
  private String dateToString(final long date) {
    if (date < 0) {
      return "-";
    }
    final DateTranslator dateTranslator = (DateTranslator.getInstance());
    final String formDate = dateTranslator.translate(new Date(date));
    return formDate;
  }

  /**
   * Formatador de taxa.
   * 
   * @param rate taxa.
   * @return texto
   */
  private String rateToString(final double rate) {
    if (rate < 0) {
      return "-";
    }
    final String text = String.format("%.1f kb/s", rate);
    return text;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getTableCellRendererComponent(final JTable table,
    final Object value, final boolean isSelected, final boolean hasFocus,
    final int row, final int column) {
    final Component renderer =
      DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected,
        hasFocus, row, column);
    final JLabel label = ((JLabel) renderer);
    label.setOpaque(true);
    label.setIcon(null);
    label.setHorizontalAlignment(SwingConstants.LEFT);
    label.setForeground(Color.black);
    label.setToolTipText(null);

    if (column == 0) {
      final FileTransferRequestStatus status =
        (FileTransferRequestStatus) value;
      label.setHorizontalAlignment(SwingConstants.CENTER);
      final Icon icon = FileTransferClientUI.getStatusIcon(status);
      label.setIcon(icon);
      label.setText(null);
      label.setToolTipText(FileTransferClientUI.getStatusTooltip(status));
    }
    else if (column == 1) {
      label.setHorizontalAlignment(SwingConstants.CENTER);
      final FileTransferRequestType type = (FileTransferRequestType) value;
      final Icon icon = FileTransferClientUI.getTypeIcon(type);
      label.setIcon(icon);
      label.setText(null);
      label.setToolTipText(FileTransferClientUI.getTypeTooltip(type));
    }
    else if (column == 2) {
      if (value == null) {
        label.setText("???");
      }
      else {
        final User user = (User) value;
        label.setText(user.getLogin() + " - " + user.getName());
      }
    }
    else if (column == 3) {
      final double perc = (Double) value;
      if (perc < 0) {
        label.setHorizontalAlignment(SwingConstants.CENTER);
        label.setText("???");
        return label;
      }
      final JProgressBar prog = new JProgressBar();
      prog.setStringPainted(true);
      prog.setMinimum(0);
      prog.setMaximum(100);
      prog.setValue((int) Math.round(perc));
      prog.setString(String.format("%.1f %%", perc));
      return prog;
    }
    else if (column == 4) {
      final String path = (String) value;
      label.setHorizontalAlignment(SwingConstants.LEFT);
      label.setText(path);
    }
    else if (column == 5) {
      final long size = (Long) value;
      if (size < 0) {
        label.setHorizontalAlignment(SwingConstants.CENTER);
      }
      else {
        label.setHorizontalAlignment(SwingConstants.RIGHT);
      }
      final ApplicationManager mgr = ApplicationManager.getInstance();
      label.setText(FormatUtils.formatSize(size, 2, mgr.getLocale()));
    }
    else if (column == 6) {
      final double rate = (Double) value;
      label.setHorizontalAlignment(SwingConstants.RIGHT);
      label.setText(rateToString(rate));
    }
    else if (column == 7) {
      final long qTime = (Long) value;
      label.setHorizontalAlignment(SwingConstants.CENTER);
      label.setText(dateToString(qTime));
    }
    else if (column == 8) {
      final long sTime = (Long) value;
      label.setHorizontalAlignment(SwingConstants.CENTER);
      label.setText(dateToString(sTime));
    }
    else if (column == 9) {
      final long eTime = (Long) value;
      label.setHorizontalAlignment(SwingConstants.CENTER);
      label.setText(dateToString(eTime));
    }
    else if (column == 10) {
      final String err = (String) value;
      label.setHorizontalAlignment(SwingConstants.LEFT);
      if (err != null) {
        label.setText(err);
        label.setForeground(Color.RED);
      }
      else {
        label.setText("-");
      }
    }

    return label;
  }

  /**
   * Construtor
   */
  public QueueRenderer() {
  }
}