/*
 * $Id:$
 */

package csbase.client.applications.filetransferclient.panels.remotepanel;

import java.util.Comparator;

import csbase.logic.filetransferservice.FileTransferElement;

/**
 * @author Tecgraf/PUC-Rio
 */
class RemoteTypeComparator implements Comparator<FileTransferElement> {
  /**
   * {@inheritDoc}
   */
  @Override
  public int compare(final FileTransferElement f1, final FileTransferElement f2) {
    if (f1.isLink() && !f2.isLink()) {
      return 1;
    }
    if (!f1.isLink() && f2.isLink()) {
      return -1;
    }
    if (f1.isDirectory() && !f2.isDirectory()) {
      return -1;
    }
    if (!f1.isDirectory() && f2.isDirectory()) {
      return 1;
    }
    final String n1 = f1.getName();
    final String n2 = f2.getName();
    return n1.compareTo(n2);
  }
}