package csbase.client.applications.flowapplication.actions;

import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.applications.flowapplication.FlowApplicationUI;
import csbase.client.applications.flowapplication.graph.OrthogonalLinkGraphLayout;

/**
 * Ao de aplicar o {@link OrthogonalLinkGraphLayout} no fluxo corrente.
 */
public class OrthogonalLinkLayoutAction extends GraphLayoutAction {

  /**
   * Construtor.
   * 
   * @param application A aplicao construtura de fluxos.
   */
  public OrthogonalLinkLayoutAction(FlowApplication application) {
    super(application, FlowApplicationUI.ORTHOGONAL_LINK_ICON,
      new OrthogonalLinkGraphLayout());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected boolean usePreview() {
    return false;
  }

}
