package csbase.client.applications.flowapplication.filters;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.messages.HideHintMessage;
import csbase.client.applications.flowapplication.messages.PickElementMessage;
import csbase.client.applications.flowapplication.messages.ShowHintMessage;

/**
 * Filtro de hint
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class HintElementFilter extends WorkspaceFilter {

  /**
   * Elemento corrente
   */
  private GraphElement currentElement;

  /**
   * Construtor
   * 
   * @param workspace workspace
   */
  public HintElementFilter(final Workspace workspace) {
    super(workspace);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void callbackButton(final Point2D pt, final MouseEvent ev) {
    new HideHintMessage().sendVS(this);
    super.callbackButton(pt, ev);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void callbackMove(final Point2D pt, final MouseEvent ev) {
    if (this.currentElement != null) {
      new HideHintMessage().sendVS(this);
    }
    final PickElementMessage message = new PickElementMessage(pt);
    message.sendVO(this);
    this.currentElement = message.getElement();
    if (this.currentElement != null) {
      final String hint = this.currentElement.getHint(pt);
      if (hint != null) {
        new ShowHintMessage(hint).sendVS(this);
      }
    }
    super.callbackMove(pt, ev);
  }
}
