package csbase.client.applications.flowapplication.filters;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.swing.JComponent;

import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.messages.GetPopupMessage;
import csbase.client.applications.flowapplication.messages.PickElementMessage;
import csbase.client.applications.flowapplication.messages.PickGraphMessage;
import csbase.client.applications.flowapplication.messages.SelectElementMessage;
import csbase.client.applications.flowapplication.messages.SelectElementsMessage;
import csbase.client.applications.flowapplication.messages.ShowPopupMessage;

/**
 * Filtro de popup.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class PopupFilter extends WorkspaceFilter {

  /**
   * Construtor
   * 
   * @param workspace workspace
   */
  public PopupFilter(final Workspace workspace) {
    super(workspace);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void callbackButton(final Point2D pt, final MouseEvent ev) {
    if (ev.isPopupTrigger()) {
      final PickElementMessage pickElementMessage = new PickElementMessage(pt);
      if (pickElementMessage.sendVO(this)) {
        final GraphElement element = pickElementMessage.getElement();
        if (!element.isSelected()) {
          final PickGraphMessage pickGraphMessage = new PickGraphMessage();
          pickGraphMessage.sendVO(this);
          final Graph graph = pickGraphMessage.getGraph();
          final Set<GraphElement> selectedElements =
            graph.getSelectedElements();
          if (selectedElements.size() > 1) {
            final Set<GraphElement> elementsToSelect =
              new HashSet<GraphElement>();
            elementsToSelect.addAll(selectedElements);
            elementsToSelect.add(element);
            new SelectElementsMessage(elementsToSelect).sendVO(this);
          }
          else {
            new SelectElementMessage(element, pt).sendVO(this);
          }
        }
      }
      final GetPopupMessage getPopupMessage = new GetPopupMessage(pt);
      getPopupMessage.sendVO(this);
      final List<JComponent> componentList =
        getPopupMessage.getPopupComponentList();
      if (!componentList.isEmpty()) {
        final ShowPopupMessage showPopupMessage =
          new ShowPopupMessage(pt, componentList);
        showPopupMessage.sendVS(this);
      }
      return;
    }
    super.callbackButton(pt, ev);
  }
}
