package csbase.client.applications.flowapplication.graph;

import tecgraf.vix.VO;

/**
 * A classe base para implementaes de decoraes.
 * 
 * @param <T> O tipo do VO utilizado pela decorao.
 */
public abstract class AbstractGraphNodeDecoration<T extends VO> implements
  GraphNodeDecoration<T> {

  /** cone que representa a decorao. */
  protected T vo;

  /**
   * O texto que descreve a decorao, usado como dica.
   */
  protected String description;

  /**
   * Construtor.
   * 
   * @param vo o vo.
   * @param description a descrio.
   */
  public AbstractGraphNodeDecoration(T vo, String description) {
    this.vo = vo;
    this.description = description;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getDescription() {
    return description;
  }

  /**
   * Atribui a descrio.
   * 
   * @param description A descrio
   */
  public void setDescription(final String description) {
    this.description = description;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public T getVO() {
    return vo;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public double getWidth() {
    if (this.vo != null) {
      return this.vo.getBounds2D().getWidth();
    }
    else {
      return 0;
    }

  }

  /**
   * {@inheritDoc}
   */
  @Override
  public double getHeight() {
    if (this.vo != null) {
      return this.vo.getBounds2D().getHeight();
    }
    else {
      return 0;
    }
  }

}