package csbase.client.applications.flowapplication.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

/**
 * Ponto de grafo.
 * 
 * @author Tecgraf/PUC-Rio
 */
final class GraphPoint {
  private static final Color BACKGROUND_COLOR = Color.WHITE;
  private static final Stroke BORDER_STROKE = new BasicStroke(0f);
  private static final Color BORDER_COLOR = Color.BLACK;
  private static final int SIDE = 6;
  private static final Dimension DIMENSION = new Dimension(SIDE, SIDE);
  private Point startPoint;
  private Point centerPoint;
  private Rectangle boundBox;

  /**
   * Construtor
   * 
   * @param x x
   * @param y y
   */
  GraphPoint(final double x, final double y) {
    final Point point = new Point();
    point.setLocation(x, y);
    setLocation(x, y);
  }

  /**
   * Construtor
   * 
   * @param point ponto.
   */
  GraphPoint(final Point2D point) {
    this(point.getX(), point.getY());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(final Object obj) {
    if (obj == null) {
      return false;
    }
    if (!(obj instanceof GraphPoint)) {
      return false;
    }
    final GraphPoint point = (GraphPoint) obj;
    return this.boundBox.contains(point.centerPoint);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int hashCode() {
    return this.centerPoint.hashCode();
  }

  /**
   * Paint
   * 
   * @param g graphics
   */
  public void paint(final Graphics2D g) {
    final int x = (int) this.startPoint.getX();
    final int y = (int) this.startPoint.getY();
    g.setPaint(BACKGROUND_COLOR);
    g.fillRect(x, y, SIDE, SIDE);
    g.setPaint(BORDER_COLOR);
    g.setStroke(BORDER_STROKE);
    g.drawRect(x, y, SIDE, SIDE);
  }

  Rectangle2D getBounds() {
    return this.boundBox;
  }

  Point2D getLocation() {
    final Point point = new Point();
    point.setLocation(this.centerPoint);
    return point;
  }

  void setLocation(final double x, final double y) {
    this.centerPoint = new Point();
    this.centerPoint.setLocation(x, y);
    this.startPoint = new Point();
    this.startPoint.setLocation(x - SIDE / 2, y - SIDE / 2);
    this.boundBox = new Rectangle();
    this.boundBox.setLocation(this.startPoint);
    this.boundBox.setSize(DIMENSION);
  }
}
