package csbase.client.applications.flowapplication.graph.actions;

import java.awt.event.ActionEvent;

import csbase.client.applications.flowapplication.FlowApplicationUI;
import csbase.client.applications.flowapplication.FlowTransferable;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.filters.AddGraphPopupActionFilter;
import csbase.client.applications.flowapplication.filters.WorkspaceFilter;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.messages.CopyMessage;
import csbase.logic.algorithms.flows.Flow;

/**
 * Ao de menu popup que copia elementos de fluxo, incluindo o valor de seus
 * parmetros.
 */
public class CopySelectedElementsAction extends GraphAction {

  /**
   * Cria a ao.
   * 
   * @param graph O grafo (No aceita {@code null}).
   */
  public CopySelectedElementsAction(final Graph graph) {
    super(graph, CopySelectedElementsAction.class.getName() + ".name",
      FlowApplicationUI.COPY_NODE_ICON);
    setEnabled(graph.hasSelectedElements());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent event) {
    Graph graph = getGraph();
    /*
     * Cria um novo fluxo somente com os ns selecionados para cpia e o coloca
     * na rea de tranferncia
     */
    Flow flow =
      Graph.toFlow(null, null, graph.getSelectedNodes(), graph
        .getSelectedLinks());
    new CopyMessage(new FlowTransferable(flow)).sendVS(graph);
  }

  /**
   * Cria o filtro que cadastra a ao no menu popup.
   * 
   * @param workspace A rea de trabalho (No aceita {@code null}).
   * 
   * @return O filtro.
   */
  public static WorkspaceFilter createFilter(final Workspace workspace) {
    if (workspace == null) {
      throw new IllegalArgumentException("O parmetro workspace est nulo.");
    }
    return new AddGraphPopupActionFilter(workspace) {
      @Override
      protected GraphAction createAction(final Graph graph) {
        return new CopySelectedElementsAction(graph);
      }
    };
  }

}
