package csbase.client.applications.flowapplication.graph.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;

import csbase.client.applications.flowapplication.FlowApplicationUI;
import csbase.client.applications.flowapplication.FlowTransferable;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.filters.AddGraphPopupActionFilter;
import csbase.client.applications.flowapplication.filters.WorkspaceFilter;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.messages.CheckClipboardFlavorMessage;
import csbase.client.applications.flowapplication.messages.PasteMessage;
import csbase.client.applications.flowapplication.messages.SelectElementsMessage;

/**
 * Ao de menu popup que "cola" um n de fluxo previamente copiado, incluindo o
 * valor de seus parmetros.
 */
public class PasteSelectedElementsAction extends GraphAction {

  /**
   * A rea de trabalho onde a ao ser feita
   */
  private Workspace workspace;

  /**
   * Cria a ao.
   * 
   * @param graph O grafo.
   * @param workspace a rea de trabalho onde a ao ser feita.
   */
  public PasteSelectedElementsAction(Graph graph, Workspace workspace) {
    super(graph, PasteSelectedElementsAction.class.getName() + ".name",
      FlowApplicationUI.PASTE_NODE_ICON);
    this.workspace = workspace;
    boolean canPaste =
      CheckClipboardFlavorMessage.canPasteFromClipboard(getGraph(),
        FlowTransferable.DATA_FLAVOR);
    setEnabled(canPaste);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent event) {
    final Graph graph = getGraph();
    final PasteMessage pasteMessage = new PasteMessage();
    pasteMessage.sendVS(graph);
    if (pasteMessage.getTransferable() != null) {
      pasteMessage.sendVO(graph);
      Collection<GraphElement> elements = pasteMessage.getAffectedElements();
      if (elements != null) {
        workspace.sendVO(new SelectElementsMessage(elements));
      }
    }
  }

  /**
   * Cria o filtro que cadastra a ao no menu popup.
   * 
   * @param workspace A rea de trabalho (No aceita {@code null}).
   * 
   * @return O filtro.
   */
  public static WorkspaceFilter createFilter(final Workspace workspace) {
    if (workspace == null) {
      throw new IllegalArgumentException("O parmetro workspace est nulo.");
    }
    return new AddGraphPopupActionFilter(workspace) {

      /**
       * {@inheritDoc}
       */
      @Override
      protected GraphAction createAction(final Graph graph) {
        return new PasteSelectedElementsAction(graph, workspace);
      }
    };
  }

}
