package csbase.client.applications.flowapplication.messages;

import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingConstants;

import tecgraf.vix.Message;

public final class GetPopupMessage extends Message {
  private final Point2D point;
  private final List<JComponent> popupComponentList;

  public GetPopupMessage(final Point2D point) {
    this.point = (Point2D) point.clone();
    this.popupComponentList = new LinkedList<JComponent>();
  }

  public void addPopupAction(final Action action) {
    this.popupComponentList.add(new JMenuItem(action));
  }

  public Point2D getPoint() {
    return (Point2D) this.point.clone();
  }

  public List<JComponent> getPopupComponentList() {
    return Collections.unmodifiableList(this.popupComponentList);
  }

  public void startGroupActions() {
    if (!this.popupComponentList.isEmpty()) {
      this.popupComponentList.add(new JSeparator(SwingConstants.HORIZONTAL));
    }
  }
}
