package csbase.client.applications.flowapplication.multiflow;

import java.awt.BorderLayout;

import javax.swing.JComponent;
import javax.swing.JPanel;

import tecgraf.javautils.gui.StatusBar;
import csbase.client.applications.Application;
import csbase.client.util.csvpanel.CSVExceptionNotification;
import csbase.client.util.csvpanel.CSVPanel;
import csbase.client.util.event.EventListener;
import csbase.logic.ClientFile;

/**
 * Janela de visulizao de arquivos CSV.
 */
public class CSVPreviewDialog extends AbstractMultipleFlowConfigurationDialog {

  /**
   * Painel de visualizao de dados CSV.
   */
  private CSVPanel csvPanel;

  /**
   * Barra de status da visualizao.
   */
  private StatusBar statusBar;

  /**
   * Dados do CSV.
   */
  private String[][] data;

  /**
   * Nmero de linhas que devem ser consideradas como cabealho. Se igual a
   * zero, no usa nenhuma das linhas no cabealho.
   */
  private int numRowsAsHeader;

  /**
   * Construtor.
   * 
   * @param application a aplicao dona dessa janela.
   * @param file O arquivo de configurao selecionado para a exportao.
   * @param numRowsAsHeader Nmero de linhas do CSV que devem ser consideradas
   *        como cabealho.
   */
  public CSVPreviewDialog(Application application, ClientFile file,
    int numRowsAsHeader) {
    this(application, file, null, numRowsAsHeader);
  }

  /**
   * Construtor.
   * 
   * @param application a aplicao dona dessa janela.
   * @param file O arquivo de configurao selecionado para a exportao.
   * @param data Dados a serem visualizados na janela.
   * @param numRowsAsHeader Nmero de linhas do CSV que devem ser consideradas
   *        como cabealho.
   */
  public CSVPreviewDialog(Application application, ClientFile file,
    String[][] data, int numRowsAsHeader) {
    super(application, file);
    this.data = data;
    this.numRowsAsHeader = numRowsAsHeader;
    this.statusBar = new StatusBar();
    this.csvPanel = new CSVPanel();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected JComponent createMainComponent() {
    JPanel panel = new JPanel(new BorderLayout());
    csvPanel
      .addExceptionListener(new EventListener<CSVExceptionNotification>() {
        @Override
        public void eventFired(CSVExceptionNotification event) {
          statusBar.setError(event.getMessage());
        }
      });
    panel.add(csvPanel, BorderLayout.CENTER);
    panel.add(statusBar, BorderLayout.SOUTH);
    statusBar.showStatusBar();
    if (data != null) {
      csvPanel.setData(data, false);
    }
    else {
      csvPanel.openFile(configurationFile, false);
    }
    csvPanel.setNumRowsAsHeader(numRowsAsHeader);
    return panel;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected boolean validateFields() {
    if (!statusBar.getText().trim().isEmpty()) {
      getApplication().showError(statusBar.getText());
      return false;
    }
    return super.validateFields();
  }

}
