package csbase.client.applications.flowapplication.multiflow;

import java.awt.GridBagLayout;

import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

import tecgraf.javautils.gui.GBC;
import csbase.client.applications.Application;
import csbase.client.util.csvpanel.columns.ClientFileChooserTextPanel;
import csbase.client.util.csvpanel.columns.ClientFileChooserTextPanel.ClientFileLocation;
import csbase.client.util.filechooser.ClientFileChooserSelectionMode;
import csbase.client.util.filechooser.ClientFileChooserType;
import csbase.logic.ClientFile;

/**
 * Janela de exportao de arquivo de configurao para execuo de mltiplos
 * fluxos.
 */
public class ExportMultipleFlowConfigurationDialog extends
  AbstractMultipleFlowConfigurationDialog {

  /**
   * O campo de nmero de execues a serem exportadas no arquivo de
   * configurao.
   */
  private JTextField executionNumberField;

  /**
   * Indica se uma janela de visualizao do arquivo de configurao deve ser
   * mostrada.
   */
  private JCheckBox previewCSV;

  /**
   * Painel de seleo de arquivo de configurao.
   */
  private ClientFileChooserTextPanel chooserPanel;

  /**
   * Construtor.
   * 
   * @param application a aplicao dona dessa janela.
   * @param file O arquivo de configurao selecionado para a exportao.
   */
  public ExportMultipleFlowConfigurationDialog(Application application,
    ClientFile file) {
    super(application, file);
  }

  /**
   * Construtor.
   * 
   * @param application a aplicao dona dessa janela.
   */
  public ExportMultipleFlowConfigurationDialog(Application application) {
    super(application);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected JPanel createMainComponent() {
    JPanel contentPanel = new JPanel(new GridBagLayout());
    final Border border =
      BorderFactory.createEtchedBorder(EtchedBorder.LOWERED);
    contentPanel.setBorder(border);
    GBC gbc = new GBC().insets(5, 5, 5, 5).west().weighty(1);

    JLabel executionNumberLabel =
      new JLabel(
        getString("ExportMultipleFlowConfigurationDialog.numExecsLabel"));
    contentPanel.add(executionNumberLabel, gbc);
    executionNumberField = new JTextField(2);
    contentPanel.add(executionNumberField, new GBC(gbc).gridx(1).pushx());

    JLabel configurationFileLabel =
      new JLabel(
        getString("ExportMultipleFlowConfigurationDialog.configFileLabel"));
    contentPanel.add(configurationFileLabel, new GBC(gbc).gridy(1));

    chooserPanel =
      new ClientFileChooserTextPanel(this, CONFIGURATION_FILE_TYPE,
        ClientFileChooserType.SAVE, ClientFileChooserSelectionMode.FILES_ONLY,
        ClientFileLocation.ANY);
    contentPanel.add(chooserPanel, new GBC(gbc).gridy(1).gridx(1));

    previewCSV =
      new JCheckBox(
        getString("ExportMultipleFlowConfigurationDialog.previewCSVLabel"),
        true);
    contentPanel.add(previewCSV, new GBC(gbc).gridy(3).width(2));

    return contentPanel;
  }

  /**
   * Indica se a opo de mostrar uma janela de visualizao do arquivo de
   * configurao foi selecionada.
   * 
   * @return verdadeiro se a opo foi selecionada ou falso, caso contrrio.
   */
  public boolean showPreview() {
    return previewCSV.isSelected();
  }

  /**
   * Obtm o nmero de execues a serem exportadas no arquivo de configurao
   * para execuo de mltiplos fluxo.
   * 
   * @return o nmero de execues ou nulo, se a exportao for cancelada.
   */
  public Integer getExecutionNumber() {
    if (isConfirmed() && validateExecutionNumber()) {
      return extractExecutionNumber();
    }
    else {
      return null;
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected boolean validateFields() {
    setConfigurationFile(chooserPanel.getSelectedFile());
    return validateExecutionNumber() && super.validateFields();
  }

  /**
   * Valida o nmero de execues preenchido pelo usurio. O valor precisa ser
   * um inteiro maior que zero. Caso no seja vlido, uma janela de erro 
   * mostrada.
   * 
   * @return verdadeiro se o valor preenchido  vlido ou falso, caso contrrio.
   */
  private boolean validateExecutionNumber() {
    Integer numExecs = extractExecutionNumber();
    if (numExecs == null || numExecs <= 0) {
      getApplication().showError(
        getString("ExportMultipleFlowConfigurationDialog.invalidNumExecsError",
          new Object[] { numExecs }));
      return false;
    }
    return true;
  }

  /**
   * Extrai o nmero de execues preenchido pelo usurio.
   * 
   * @return o nmero de execues ou nulo se o valor preenchido no for um
   *         inteiro vlido.
   */
  private Integer extractExecutionNumber() {
    Integer numExecs;
    String text = executionNumberField.getText();
    try {
      numExecs = Integer.valueOf(text);
      return numExecs;
    }
    catch (NumberFormatException e) {
      return null;
    }
  }

}
