package csbase.client.applications.flowapplication.zoom;

/**
 * <p>
 * Modelo de dados para widgets relacionadas ao controle de zoom, como slider,
 * spinners e aes de zoom in e zoom out.
 * </p>
 * 
 * <p>
 * Ele utiliza o conceito de incrementos/decrementos unitrios e
 * incrementos/decrementos em bloco. Incrementos e decrementos unitrios so
 * usados em componentes que fazem ajuste fino do zoom como o spinner.
 * Incrementos/decrementos em bloco so utilizados em componentes que fazem
 * alteraes bruscas do zoom como as aes de zoom in e zoom out e sliders.
 * </p>
 * 
 * <p>
 * Existem 5 valores importantes no modelo de zoom: valor corrente, valor
 * mnimo, valor mximo, incremento/decremento de bloco e incremento/decremento
 * unitrio. As seguintes relaes tm que ser respeitadas:<br>
 * 
 * <ol>
 * <li>
 * Todos os valores tm que ser positivos;</li>
 * <li>
 * Valor mnimo &lt;= valor atual &lt;= valor mximo;</li>
 * <li>
 * Incremento/decremento unitrio &lt;= incremento/decremento de bloco.</li>
 * </ol>
 * </p>
 * 
 * @author lmoreira
 */
public interface ZoomModel {
  /**
   * Adiciona um listener de zoom a este modelo.
   * 
   * @param listener O listener.
   */
  void addListener(ZoomListener listener);

  /**
   * Verifica se podemos aumentar o zoom utilizando um incremento de bloco.
   * 
   * @return <code>true</code> se podemos ou <code>false</code> caso contrrio.
   */
  boolean hasNextBlockValue();

  /**
   * Verifica se podemos diminuir o zoom utilizando um decremento de bloco.
   * 
   * @return <code>true</code> se podemos ou <code>false</code> caso contrrio.
   */
  boolean hasPreviousBlockValue();

  /**
   * Verifica se podemos aumentar o zoom utilizando um incremento unitrio.
   * 
   * @return <code>true</code> se podemos ou <code>false</code> caso contrrio.
   */
  boolean hasNextUnitValue();

  /**
   * Verifica se podemos diminuir o zoom utilizando um decremento unitrio.
   * 
   * @return <code>true</code> se podemos ou <code>false</code> caso contrrio.
   */
  boolean hasPreviousUnitValue();

  /**
   * Obtm o valor do incremento de bloco.
   * 
   * @return O valor do incremento.
   */
  double getBlockIncrement();

  /**
   * Obtm o valor mximo do zoom.
   * 
   * @return O valor mximo.
   */
  double getMaxValue();

  /**
   * Obtm o valor mnimo do zoom.
   * 
   * @return O valor mnimo.
   */
  double getMinValue();

  /**
   * Obtm o valor do zoom usando um incremento de bloco.
   * 
   * @return O valor do zoom.
   */
  double getNextBlockValue();

  /**
   * Obtm o valor do zoom usando um incremento unitrio.
   * 
   * @return O valor do zoom.
   */
  double getNextUnitValue();

  /**
   * Obtm o valor do zoom usando um decremento de bloco.
   * 
   * @return O valor do zoom.
   */
  double getPreviousBlockValue();

  /**
   * Obtm o valor do zoom usando um decremento unitrio.
   * 
   * @return O valor do zoom.
   */
  double getPreviousUnitValue();

  /**
   * Obtm o valor do incremento/decremento unitrio.
   * 
   * @return O valor do incremento/decremento.
   */
  double getUnitIncrement();

  /**
   * Obtm o valor atual do zoom.
   * 
   * @return valor.
   */
  double getValue();

  /**
   * Obtm o valor padro do zoom.
   * 
   * @return valor.
   */
  double getStandardValue();

  /**
   * Obtm o valor do zoom no qual todo o contedo pode ser visto
   * simultaneamente.
   * 
   * @return valor.
   */
  double getFitValue();

  /**
   * Remove um listener de zoom.
   * 
   * @param listener O listener.
   */
  void removeListener(ZoomListener listener);

  /**
   * <p>
   * Ajusta o valor do zoom.
   * </p>
   * 
   * <ol>
   * <li>
   * Se o valor fornecido for maior do que o valor mximo, o valor corrente ser
   * o valor mximo;</li>
   * <li>
   * Se o valor fornecido for menor do que o valor mnimo, o valor corrente ser
   * o valor mnimo;</li>
   * <li>
   * Se ambas as proposies forem falsas, o valor corrente ser o valor
   * passado.</li>
   * </ol>
   * 
   * 
   * @param value O valor fornecido.
   */
  void setValue(double value);
}
