package csbase.client.applications.jobmonitor.columns;

import java.awt.Component;
import java.rmi.RemoteException;

import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

import csbase.client.algorithms.commands.cache.CommandsCache;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.jobmonitor.JobMonitorSystemInfo;
import csbase.client.applications.jobmonitor.rowmodel.JobInfoRow;
import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;
import csbase.client.facilities.configurabletable.stringprovider.IStringProvider;

/**
 * Coluna que exibe o sistema que submeteu o job atravs de uma imagem. <br/>
 * Atualmente s exibe se o sistema  CSBASE ou outro sistema qualquer.
 * 
 * @author Tecgraf
 */
public class SystemColumn extends AbstractConfigurableColumn<JobInfoRow> {

  /** Informaes do sistema definidas no arquivo de propriedades da aplicao. */
  private JobMonitorSystemInfo systemInfo;

  /**
   * Propriedade que deve ser comparada para identificar se o job foi submetido
   * pelo sistema.
   */
  private String propertyId;

  /**
   * Construtor padro.
   * 
   * @param provider - provedor de string usado para obter os tooltips das
   *        imagens.
   * @param systemInfo - informaes do sistema definidas no arquivo de
   *        propriedades da aplicao.
   * @param propertyId - propriedade que deve ser comparada para identificar se
   *        o job foi submetido pelo sistema.
   */
  public SystemColumn(JobMonitorSystemInfo systemInfo,
    IStringProvider provider, String propertyId) {
    super(systemInfo.getSystemName(), true, provider, null);
    this.systemInfo = systemInfo;
    this.propertyId = propertyId;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<?> getColumnClass() {
    return Boolean.class;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getColumnName() {
    return systemInfo.getSystemName();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Boolean getValue(JobInfoRow obj) {
    try {
      return CommandsCache.getInstance().hasCommand(obj.get(propertyId));
    }
    catch (RemoteException e) {
      return false;
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public TableCellRenderer createTableCellRenderer() {
    return new DefaultTableCellRenderer() {
      @Override
      public Component getTableCellRendererComponent(JTable table,
        Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus,
          row, column);

        Icon icon = ApplicationImages.TRANSPARENT_BALL_16;
        String toolTip = getString("tool.tip.other");

        Boolean fromSystem = (Boolean) value;
        setText(null);
        if (fromSystem) {
          icon =
            (systemInfo.getSystemIcon() != null) ? systemInfo.getSystemIcon()
              : ApplicationImages.GRAY_BALL_16;
          toolTip = getString("tool.tip.by") + " " + systemInfo.getSystemName();
        }

        setIcon(icon);
        setToolTipText(toolTip);

        return this;
      }
    };
  }

}
