/*
 * $Id:$
 */

package csbase.client.applications.projectsmanager.actions;

import java.util.List;

import javax.swing.ImageIcon;

import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.actions.core.ProjectsManagerAction;
import csbase.client.applications.projectsmanager.dialogs.StatusDialog;
import csbase.client.applications.projectsmanager.models.ProjectInfoData;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.FillProjectsTableAdminTask;
import csbase.client.applications.projectsmanager.proxy.FillProjectsTableUserTask;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.logic.UserProjectInfo;

/**
 * Ao responsvel por criar a thread que ir oter os dados dos projetos para
 * insero na tabela.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class FillProjectsTableAction extends ProjectsManagerAction {

  /**
   * Indica se o preenchimento da tabela deve ser feito no modo administrador ou
   * usurio.
   */
  final private boolean adminMode;

  /**
   * Indica se o espao ocupado dos projetos deve ser carregado tambm.
   */
  final private boolean loadOccupiedSpace;

  /**
   * Construtor
   * 
   * @param projectsManager a aplicao
   * @param adminMode indicativo de admin (uso da ao)
   * @param loadOccupiedSpace indicativo de carga de espao ocupado.
   */
  public FillProjectsTableAction(ProjectsManager projectsManager,
    boolean adminMode, boolean loadOccupiedSpace) {
    super(projectsManager);
    this.adminMode = adminMode;
    this.loadOccupiedSpace = loadOccupiedSpace;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone() throws Exception {
    ProjectsManager projectsManager = getProjectsManager();
    projectsManager.clearAllProjects();
    projectsManager.clearTable();
    projectsManager.clearFilters();
    ProjectsManagerTask<ProjectInfoData> fptt;
    if (adminMode) {
      fptt = new FillProjectsTableAdminTask(projectsManager, loadOccupiedSpace);
    }
    else {
      fptt = new FillProjectsTableUserTask(projectsManager, loadOccupiedSpace);
    }
    ApplicationFrame appFrame = projectsManager.getApplicationFrame();
    fptt.execute(appFrame, getString("FillProjectsTableAction.title"),
      getString("FillProjectsTableAction.message"));
    if (fptt.wasCancelled()) {
      fptt.showError(getString("FillProjectsTableAction.cancelled.message"));
      return;
    }
    if (fptt.getStatus() != true) {
      throw fptt.getError();
    }
    ProjectInfoData pid = fptt.getResult();
    List<ProjectsManagerData> projects = pid.getProjectsData();
    List<UserProjectInfo> failedProjects = pid.getFailedProjectsData();
    if (projects == null) {
      String errMsg =
        getString("FillProjectsTableAction.reading.error.message");
      String errTitle =
        getString("FillProjectsTableAction.reading.error.title");
      StandardDialogs.showErrorDialog(appFrame, errTitle, errMsg);
      return;
    }
    String message =
      getString("FillProjectsTableAction.project.file.error.message");
    if (failedProjects.size() > 0) {
      String conclusionMessage =
        getString("FillProjectsTableAction.project.loading.error.title");
      StatusDialog.showLoadingFailureDialog(projectsManager, message,
        failedProjects, conclusionMessage);
    }
    for (ProjectsManagerData prj : projects) {
      projectsManager.addProject(prj);
    }
    projectsManager.refreshProjectsTable();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getStandardImageIcon() {
    return ApplicationImages.ICON_REFRESH_16;
  }

}
