/*
 * $Id$
 */

package csbase.client.applications.projectsmanager.models;

import java.util.List;

import csbase.logic.UserProjectInfo;

/**
 * Estrutura que armazena lista de projetos no padro ProjectsManager
 * (ProjectsManagerData) e uma lista de strings que indicam quais projetos no
 * puderam ser abertos.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ProjectInfoData {

  /**
   * Lista de projetos abertos com sucesso.
   */
  final private List<ProjectsManagerData> projectsData;

  /**
   * Lista de nomes dos projetos que no puderam ser abertos.
   */
  final private List<UserProjectInfo> failedProjectsInfo;

  /**
   * Construtor
   * 
   * @param projectsData Lista de projetos abertos com sucesso.
   * @param failedProjectsInfo Lista de projetos que no puderam ser abertos.
   */
  public ProjectInfoData(List<ProjectsManagerData> projectsData,
    List<UserProjectInfo> failedProjectsInfo) {
    this.projectsData = projectsData;
    this.failedProjectsInfo = failedProjectsInfo;
  }

  /**
   * Retorna a lista de projetos abertos com sucesso.
   * 
   * @return a lista
   */
  public List<ProjectsManagerData> getProjectsData() {
    return projectsData;
  }

  /**
   * Retorna a lista de projetos que no puderam ser abertos.
   * 
   * @return a lista
   */
  public List<UserProjectInfo> getFailedProjectsData() {
    return failedProjectsInfo;
  }
}
