package csbase.client.applications.projectsmanager.panels.renderers;

import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;

import csbase.client.applications.projectsmanager.models.ProjectsManagerScope;

/**
 * Renderer da coluna de compartilhamento de projetos.
 * 
 * @author Tecgraf/PUC-Rio
 * 
 */
public class TableScopeRenderer extends DefaultTableCellRenderer {

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getTableCellRendererComponent(JTable table, Object value,
    boolean isSelected, boolean hasFocus, int row, int column) {
    final Component component =
      super.getTableCellRendererComponent(table, value, isSelected, hasFocus,
        row, column);
    final JLabel label = (JLabel) component;

    if (value != null) {

      if (value instanceof ProjectsManagerScope) {
        final ProjectsManagerScope scope = (ProjectsManagerScope) value;
        label.setHorizontalAlignment(SwingConstants.CENTER);
        label.setIcon(scope.getIcon());
        label.setText(null);
        label.setToolTipText(scope.getDescription());
        return label;
      }
      /*
       * Esta exceo  lanada caso o renderer receba um objeto que no seja
       * uma instncia da classe esperada.
       */
      throw new RuntimeException();
    }

    label.setHorizontalAlignment(SwingConstants.CENTER);
    label.setIcon(null);
    label.setText(null);

    return label;
  }
}
