package csbase.client.applications.projectsmanager.proxy;

import java.util.List;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.logic.ProjectAdminInfo;

/**
 * Task que procura por projetos na estrutura de projetos com alocao que no
 * estejam presentes na estrutura de projetos do ProjectsManager e os retorna.
 * 
 * Como a criao de projetos retorna um objeto CommonClientProject criado
 * quando no se usa alocao e null quando se usa, no  possvel obter
 * informao alguma do projeto quando a alocao de espao  solicitada.
 * 
 * @author jnlopes
 * 
 */
public class LocateMissingAllocatedProjectsTask extends
  ProjectsManagerTask<Boolean> {

  /**
   * Construtor
   * 
   * @param projectsManager A aplicao
   */
  public LocateMissingAllocatedProjectsTask(ProjectsManager projectsManager) {
    super(projectsManager);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void performTask() throws Exception {
    ProjectsManager projectsManager = getProjectsManager();
    List<ProjectsManagerData> projects = projectsManager.getAllProjects();
    ProjectAdminInfo[] prjAdmInfo = ProjectAdminInfo.getAll();
    if (prjAdmInfo == null) {
      setResult(false);
      return;
    }
    boolean found = false;
    for (ProjectAdminInfo p : prjAdmInfo) {
      found = false;
      for (int i = 0; i < projects.size(); i++) {
        ProjectsManagerData pmd = projects.get(i);
        if (p.getProjectName().equals(pmd.getProjectName())) {
          found = true;
          break;
        }
      }
      if (!found) {
        ProjectsManagerData tmp =
          new ProjectsManagerData(p.getProjectId(), p.getProjectName(),
            p.getOwnerId());
        tmp
          .setProjectSpaceAllocation(ProjectSpaceAllocation.WAITING_ALLOCATION);
        tmp.setRequestedSpace(p.getAreaRequestSize());
        projectsManager.addProject(tmp);
      }
    }
    setResult(true);
  }
}
