package csbase.client.applications.projectsmanager.proxy;

import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.CommandPersistenceServiceInterface;
import csbase.remote.ProjectServiceInterface;

/**
 * Remote task para remoo de projetos.
 *
 * @author jnlopes
 *
 */
public class RemoveProjectTask extends ProjectsManagerTask<Boolean> {

  /**
   * Informaes dos projetos.
   */
  private List<ProjectsManagerData> projects;

  /**
   * Construtor
   *
   * @param projectsManager A aplicao
   * @param projects Informaes dos projetos.
   */
  public RemoveProjectTask(ProjectsManager projectsManager,
    List<ProjectsManagerData> projects) {
    super(projectsManager);
    this.projects = projects;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void performTask() {
    boolean res = true;
    ProjectServiceInterface psi = ClientRemoteLocator.projectService;
    CommandPersistenceServiceInterface cpsi =
      ClientRemoteLocator.commandPersistenceService;
    try {
      for (ProjectsManagerData prj : projects) {
        Set<CommandInfo> runningCommands = cpsi.getStatusCommandInfos(
          prj.getProjectId(), Arrays.asList(CommandStatus.FINISHED), false);
        if (runningCommands.size() > 0) {
          this.cancelTask();
          res = false;
          break;
        }
        psi.removeProject(prj.getProjectId());
      }
    }
    catch (RemoteException re) {
      re.printStackTrace();
      res = false;
    }
    setResult(res);
  }
}
