package csbase.client.applications.projectsmanager.proxy;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;

/**
 * Task para modificao do status de alocao de projetos.
 * 
 * @author jnlopes
 */
public class StatusModificationTask extends
  ProjectsManagerTask<List<ProjectsManagerData>> {

  /**
   * Informaes dos projetos.
   */
  private List<ProjectsManagerData> projects;

  /**
   * Status de alocao do projeto.
   */
  private ProjectSpaceAllocation targetAllocationStatus;

  /**
   * Espao (em GB) que deve ser reservado ao projeto.
   */
  private int reservedSpace;

  /**
   * Construtor
   * 
   * @param projectsManager A aplicao.
   * @param projects Informaes dos projetos.
   * @param targetAllocationStatus Status de alocao do projeto.
   * @param reservedSpace Espao (em GB) que foi alocado ao projeto.
   */
  public StatusModificationTask(ProjectsManager projectsManager,
    List<ProjectsManagerData> projects,
    ProjectSpaceAllocation targetAllocationStatus, int reservedSpace) {
    super(projectsManager);
    this.projects = projects;
    this.targetAllocationStatus = targetAllocationStatus;
    this.reservedSpace = reservedSpace;
  }

  /**
   * Construtor
   * 
   * @param projectsManager A aplicao.
   * @param projects Informaes dos projetos.
   */
  public StatusModificationTask(ProjectsManager projectsManager,
    List<ProjectsManagerData> projects) {
    this(projectsManager, projects, ProjectSpaceAllocation.NO_ALLOCATION, 0);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void performTask() {
    List<ProjectsManagerData> list = new ArrayList<ProjectsManagerData>();
    ProjectServiceInterface psi = ClientRemoteLocator.projectService;
    for (ProjectsManagerData prj : projects) {
      try {
        if (targetAllocationStatus == ProjectSpaceAllocation.NO_ALLOCATION) {
          psi.setAllocatedProjectAsUnallocated(prj.getProjectId());
        }
        else {
          if (targetAllocationStatus == ProjectSpaceAllocation.ALLOCATED) {
            psi.setUnallocatedProjectAsAllocated(prj.getProjectId(),
              reservedSpace);
          }
          else {
            psi
              .setUnallocatedProjectAsLocked(prj.getProjectId(), reservedSpace);
          }
        }
      }
      catch (RemoteException re) {
        list.add(prj);
      }
    }
    setResult(list);
  }
}
