/**
 * $Id$
 */

package csbase.client.applications.projectsmanager.proxy;

import java.rmi.RemoteException;
import java.util.List;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.ProjectsManagerUI;
import csbase.client.applications.projectsmanager.models.ProjectHistoryBlockType;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;

/**
 * Task para remover um usurio de um projeto (do qual ele no  dono).
 * 
 * @author jnlopes
 * 
 */
public class UserRemovalFromProjectTask extends ProjectsManagerTask<Boolean> {

  /**
   * Informaes dos projetos.
   */
  private List<ProjectsManagerData> projects;

  /**
   * Construtor
   * 
   * @param projectsManager A aplicao
   * @param projects Informaes dos projetos.
   */
  public UserRemovalFromProjectTask(ProjectsManager projectsManager,
    List<ProjectsManagerData> projects) {
    super(projectsManager);
    this.projects = projects;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void performTask() {
    boolean error = false;
    ProjectsManager projectsManager = getProjectsManager();
    User user = projectsManager.getUser();
    Object currentUserID = user.getId();
    ProjectServiceInterface psi = ClientRemoteLocator.projectService;
    for (ProjectsManagerData prj : projects) {
      try {
        CommonClientProject ccp = psi.openProject(prj.getProjectId(), false);
        /*
         * Tratamento de adio de mensagens no histrico.
         */
        ProjectsManagerUI.addAutomaticHistoryBlock(ccp,
          ProjectHistoryBlockType.PROJECT_SELF_REMOVAL);
        if (!ccp.removeUser(currentUserID)) {
          error = true;
        }
        ccp.close(false);
      }
      catch (RemoteException e) {
        StandardErrorDialogs.showErrorDialog(projectsManager
          .getApplicationFrame(), e);
        error = true;
      }
    }
    projectsManager.refreshProjectsTable();
    setResult(!error);
  }
}
