package csbase.client.applications.projectsynchronization;

import csbase.logic.applicationservice.ApplicationRegistry;

import java.awt.CardLayout;
import java.awt.GridLayout;

import javax.swing.JPanel;


public class ContainerSelectionProjects {
    private JPanel rootPanel;
    private JPanel projectsPanel;
    private PanelProjectsSelection projectsSelectionA;
    private PanelProjectsSelection projectsSelectionB;
    private ApplicationRegistry registry;

    ContainerSelectionProjects(ApplicationRegistry registry) {
        this.registry = registry;
    }

    public JPanel getRootPanel() {
        if (rootPanel == null) {
            rootPanel = new JPanel();

            CardLayout cardLayout = new CardLayout();
            cardLayout.setHgap(3);
            cardLayout.setVgap(3);
            rootPanel.setLayout(cardLayout);
            rootPanel.add("projectsPanel", getProjectsPanel());
        }

        return rootPanel;
    }

    private JPanel getProjectsPanel() {
        if (projectsPanel == null) {
            projectsPanel = new JPanel(new GridLayout(1, 2));
            projectsPanel.add(getProjectsSelectionA());
            projectsPanel.add(getProjectsSelectionB());
        }

        return projectsPanel;
    }

    public PanelProjectsSelection getProjectsSelectionA() {
        if (projectsSelectionA == null) {
            projectsSelectionA = new PanelProjectsSelection(registry.getString(
                        "step2.project.a"), registry);
        }

        return projectsSelectionA;
    }

    public PanelProjectsSelection getProjectsSelectionB() {
        if (projectsSelectionB == null) {
            projectsSelectionB = new PanelProjectsSelection(registry.getString(
                        "step2.project.b"), registry);
        }

        return projectsSelectionB;
    }
}
