package csbase.client.applications.projectsynchronization;

import csbase.logic.applicationservice.ApplicationRegistry;

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PanelProjectsSelection extends JPanel {
  private JPanel projectPanel;
  private JComboBox cbProjetos;
  private ApplicationRegistry registry;

  public PanelProjectsSelection(String title, ApplicationRegistry registry) {
    super(new BorderLayout());
    this.registry = registry;
    setBorder(BorderFactory.createTitledBorder(title));
    add(getProjectPanel(), BorderLayout.CENTER);
  }

  private JPanel getProjectPanel() {
    if (projectPanel == null) {
      projectPanel = new JPanel(new GridBagLayout());
      GridBagConstraints c;
      //Servidor - label
      c = new GridBagConstraints();
      c.gridx = 0;
      c.gridy = 0;
      c.weightx = 1;
      c.anchor = GridBagConstraints.WEST;
      c.insets = new Insets(2, 2, 0, 2);
      projectPanel.add(new JLabel(registry.getString("step2.projects")), c);
      //Servidor - field
      c = new GridBagConstraints();
      c.gridx = 0;
      c.gridy = 1;
      c.weightx = 1;
      c.fill = GridBagConstraints.HORIZONTAL;
      c.insets = new Insets(0, 2, 2, 2);
      projectPanel.add(getCbProjetos(), c);
    }
    return projectPanel;
  }

  public JComboBox getCbProjetos() {
    if (cbProjetos == null) {
      cbProjetos = new JComboBox();
    }
    return cbProjetos;
  }
}
