package csbase.client.applications.projectsynchronization;

import csbase.logic.applicationservice.ApplicationRegistry;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.text.DecimalFormat;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class PanelServerSelection extends JPanel {
  private JRadioButton rdProjectLocal;
  private JRadioButton rdProjectRemote;
  private ButtonGroup bgProject;
  private JPanel projectServerInternalPanel;
  private JPanel projectLocalPanel;
  private JPanel projectRemotePanel;
  private JPanel projectSelectionServerPanel;
  private JTextField eUser;
  private JPasswordField ePassword;
  private JTextField eServer;
  private JFormattedTextField ePort;
  private ApplicationRegistry registry;

  public PanelServerSelection(
    String title, ApplicationRegistry registry, String server, String port) {
    super(new BorderLayout());
    this.registry = registry;
    setBorder(BorderFactory.createTitledBorder(title));
    add(getProjectSelectionServerPanel(), BorderLayout.NORTH);
    add(getProjectServerInternalPanel(), BorderLayout.CENTER);
    if (server != null && port != null) {
      rdProjectRemote.setSelected(true);
      eServer.setText(server);
      ePort.setText(port);
      CardLayout c = (CardLayout)getProjectServerInternalPanel()
        .getLayout();
      c.show(getProjectServerInternalPanel(), "remoto");
    }
  }

  private JPanel getProjectSelectionServerPanel() {
    if (projectSelectionServerPanel == null) {
      projectSelectionServerPanel = new JPanel();
      bgProject = new ButtonGroup();
      bgProject.add(getRdProjectLocal());
      bgProject.add(getRdProjectRemote());
      projectSelectionServerPanel.add(getRdProjectLocal());
      projectSelectionServerPanel.add(getRdProjectRemote());
    }
    return projectSelectionServerPanel;
  }

  public JRadioButton getRdProjectLocal() {
    if (rdProjectLocal == null) {
      rdProjectLocal = new JRadioButton(registry.getString("step1.local"));
      rdProjectLocal.setSelected(true);
      rdProjectLocal.setFocusable(false);
      rdProjectLocal.addActionListener(
        new ActionListener() {
          public void actionPerformed(ActionEvent e) {
            CardLayout c =
              (CardLayout)getProjectServerInternalPanel().getLayout();
            c.show(getProjectServerInternalPanel(), "local");
          }
        });
    }
    return rdProjectLocal;
  }

  public JRadioButton getRdProjectRemote() {
    if (rdProjectRemote == null) {
      rdProjectRemote = new JRadioButton(registry.getString("step1.remote"));
      rdProjectRemote.setFocusable(false);
      rdProjectRemote.addActionListener(
        new ActionListener() {
          public void actionPerformed(ActionEvent e) {
            CardLayout c =
              (CardLayout)getProjectServerInternalPanel().getLayout();
            c.show(getProjectServerInternalPanel(), "remoto");
          }
        });
    }
    return rdProjectRemote;
  }

  private JPanel getProjectServerInternalPanel() {
    if (projectServerInternalPanel == null) {
      projectServerInternalPanel = new JPanel();
      CardLayout cardLayout = new CardLayout();
      cardLayout.setHgap(3);
      cardLayout.setVgap(3);
      projectServerInternalPanel.setLayout(cardLayout);
      projectServerInternalPanel.add("local", getProjectLocalPanel());
      projectServerInternalPanel.add("remoto", getProjectRemotePanel());
    }
    return projectServerInternalPanel;
  }

  private JPanel getProjectLocalPanel() {
    if (projectLocalPanel == null) {
      projectLocalPanel = new JPanel();
    }
    return projectLocalPanel;
  }

  private JPanel getProjectRemotePanel() {
    if (projectRemotePanel == null) {
      projectRemotePanel = new JPanel(new GridBagLayout());
      GridBagConstraints c;
      //Servidor - label
      c = new GridBagConstraints();
      c.gridx = 0;
      c.gridy = 0;
      c.weightx = 1;
      c.anchor = GridBagConstraints.WEST;
      c.insets = new Insets(2, 2, 0, 2);
      projectRemotePanel.add(new JLabel(registry.getString("step1.server")), c);
      //Servidor - field
      c = new GridBagConstraints();
      c.gridx = 0;
      c.gridy = 1;
      c.weightx = 2;
      c.fill = GridBagConstraints.HORIZONTAL;
      c.insets = new Insets(0, 2, 2, 2);
      projectRemotePanel.add(getEServer(), c);
      //Servidor - label
      c = new GridBagConstraints();
      c.gridx = 1;
      c.gridy = 0;
      c.weightx = 1;
      c.anchor = GridBagConstraints.WEST;
      c.insets = new Insets(2, 2, 0, 2);
      projectRemotePanel.add(new JLabel(registry.getString("step1.port")), c);
      //Port - field
      c = new GridBagConstraints();
      c.gridx = 1;
      c.gridy = 1;
      c.weightx = 1;
      c.fill = GridBagConstraints.HORIZONTAL;
      c.insets = new Insets(0, 2, 2, 2);
      projectRemotePanel.add(getEPort(), c);
      //Usuario - label
      c = new GridBagConstraints();
      c.gridx = 0;
      c.gridy = 2;
      c.gridwidth = 2;
      c.weightx = 1;
      c.anchor = GridBagConstraints.WEST;
      c.insets = new Insets(2, 2, 0, 2);
      projectRemotePanel.add(new JLabel(registry.getString("step1.user")), c);
      //Usuario - field
      c = new GridBagConstraints();
      c.gridx = 0;
      c.gridy = 3;
      c.gridwidth = 2;
      c.weightx = 1;
      c.fill = GridBagConstraints.HORIZONTAL;
      c.insets = new Insets(0, 2, 2, 2);
      projectRemotePanel.add(getEUser(), c);
      //Senha - label
      c = new GridBagConstraints();
      c.gridx = 0;
      c.gridy = 4;
      c.gridwidth = 2;
      c.weightx = 1;
      c.anchor = GridBagConstraints.WEST;
      c.insets = new Insets(2, 2, 0, 2);
      projectRemotePanel.add(
        new JLabel(registry.getString("step1.password")), c);
      //Senha - field
      c = new GridBagConstraints();
      c.gridx = 0;
      c.gridy = 5;
      c.gridwidth = 2;
      c.weightx = 1;
      c.fill = GridBagConstraints.HORIZONTAL;
      c.insets = new Insets(0, 2, 2, 2);
      projectRemotePanel.add(getEPassword(), c);
    }
    projectRemotePanel.setPreferredSize(new Dimension(10, 250));
    return projectRemotePanel;
  }

  public JPasswordField getEPassword() {
    if (ePassword == null) {
      ePassword = new JPasswordField();
    }
    return ePassword;
  }

  public JTextField getEServer() {
    if (eServer == null) {
      eServer = new JTextField();
    }
    return eServer;
  }

  public JFormattedTextField getEPort() {
    if (ePort == null) {
      ePort = new JFormattedTextField(new DecimalFormat("#"));
      ePort.setColumns(7);
    }
    return ePort;
  }

  public JTextField getEUser() {
    if (eUser == null) {
      eUser = new JTextField();
    }
    return eUser;
  }
}
