package csbase.client.applications.projectsynchronization;

import csbase.client.desktop.RemoteTask;
import csbase.logic.ProjectSynchronizationData;
import csbase.logic.ProjectSynchronizationResult;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectSynchronizationServiceInterface;

/**
 * Task responsvel pela sincronizao de projetos.
 */
public class ProjectSynchronizationRemoteTask 
extends RemoteTask<ProjectSynchronizationResult> {
  /**
   * Conjunto de arquivos a serem sincronizados.
   */
  private ProjectSynchronizationData data;
  /**
   * Observador da sincronizao. 
   */
  private ProjectSynchronizationWizardMonitor monitor;

  /**
   * Construtor.
   * 
   * @param data dados para serem sincronizados
   * @param monitor monitor para sincronizao de projetos
   */
  public ProjectSynchronizationRemoteTask(
    ProjectSynchronizationData data, ProjectSynchronizationWizardMonitor monitor) {
    this.monitor = monitor;
    this.data = data;
  }

  @Override
  protected void performTask() throws Exception {
    ProjectSynchronizationServiceInterface psi =
      ClientRemoteLocator.projectSynchronizationService;
    setResult(psi.synchronizeProjects(data, monitor));
  }

  @Override
  protected synchronized void cancelTask() {
    super.cancelTask();
    monitor.setCancelled();
  }
}
