package csbase.client.applications.sgamonitor.actions;

import java.awt.event.ActionEvent;
import java.util.List;

import csbase.client.applications.AbstractSimpleApplicationAction;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.sgamonitor.ClusterMonitor;
import csbase.client.applications.sgamonitor.SGAMonitor;
import csbase.client.applications.sgamonitor.SimpleServerMonitor;
import csbase.logic.SGASet;

/**
 * Ao que exibe as informaes de um SGA ou de um cluster. Essa ao s pode
 * ser utilizada se apenas um objeto estiver selecionado.
 * 
 * @author Tecgraf
 */
public class DetailsSGAClusterAction extends
  AbstractSimpleApplicationAction<SGAMonitor> {

  /**
   * Dilogo responsvel por apresentar as informaes dos ns de um cluster.
   */
  private ClusterMonitor clusterMonitor;

  /**
   * Dilogo responsvel por apresentar as informaes de um SGA simples.
   */
  private SimpleServerMonitor serverMonitor;

  /**
   * Construtor padro.
   * 
   * @param application - aplicao na qual esta ao est sendo executada.
   */
  public DetailsSGAClusterAction(SGAMonitor application) {
    super(application, ApplicationImages.ICON_DETAILS_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) throws Exception {

    SGAMonitor app = getApplication();

    List<SGASet> selectedSGAs = app.getSelectedSGAs();
    if (selectedSGAs.size() == 1) {

      SGASet sgaSelected = app.getSelectedSGAs().get(0);

      if (sgaSelected.isCluster()) {
        if (this.clusterMonitor == null) {
          this.clusterMonitor = new ClusterMonitor(getApplication());
          getApplication().addObserver(clusterMonitor);
        }

        clusterMonitor.updateClusterInfo(sgaSelected);
        clusterMonitor.setVisible(true);
      }
      else {
        if (this.serverMonitor == null) {
          this.serverMonitor = new SimpleServerMonitor(getApplication());
          getApplication().addObserver(serverMonitor);
        }
        serverMonitor.updateSGAInfo(sgaSelected);
        serverMonitor.setVisible(true);
      }
    }

  }
}
