package csbase.client.applications.sgamonitor.columns;

import java.awt.Component;
import java.util.Set;

import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;
import csbase.client.facilities.configurabletable.stringprovider.IStringProvider;
import csbase.logic.SGAInfo;
import csbase.logic.SGASet;

/**
 * Coluna que exibe os requisitos de um SGA simples.
 * 
 * @author Tecgraf
 */
public class RequirementsColumn extends AbstractConfigurableColumn<SGASet> {

  /**
   * Construtor padro.
   * 
   * @param id - identificador da coluna.
   * @param visible - visibilidade da coluna.
   * @param stringProvider - utilizado para obter o nome da coluna
   *        internacionalizada.
   * @param align - alinhamento da coluna.
   */
  public RequirementsColumn(String id, Boolean visible,
    IStringProvider stringProvider, Integer align) {
    super(id, visible, stringProvider, align);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<?> getColumnClass() {
    return Set.class;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getColumnName() {
    return getString(getId());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(SGASet obj) {
    //essa coluna s  usada na tabela que monitora sga's simples
    //logo, o SGASet contm apenas um SGAInfo.
    SGAInfo node = obj.getAllInfo()[0];
    return node.getRequirements();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public TableCellRenderer createTableCellRenderer() {
    return new DefaultTableCellRenderer() {
      @Override
      public Component getTableCellRendererComponent(JTable table,
        Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus,
          row, column);

        Set<?> requirements = Set.class.cast(value);
        if (requirements.size() == 0) {
          setToolTipText(null);
          setText(AbstractConfigurableColumn.NO_VALUE);
        }
        else {
          String ttTemplate = getString("tooltip.requirements.template");
          String ttEntry = getString("tooltip.requirements.entry");
          StringBuilder tooltipEntries = new StringBuilder();
          for (Object aRequirement : requirements) {
            tooltipEntries.append(String.format(ttEntry, aRequirement));
          }
          setToolTipText(String.format(ttTemplate, tooltipEntries));

          StringBuilder text = new StringBuilder();
          for (Object aRequirement : requirements) {
            text.append(aRequirement.toString()).append(",");
          }
          setText(text.length() > 0 ? text.substring(0, text.length() - 1) : "");
        }

        return this;
      }
    };
  }
}
