package csbase.client.applications.sgamonitor.columns.util;

import java.awt.Component;

import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;

/**
 * Renderizador de dados do tipo porcentagem.
 * 
 * @author Tecgraf
 */
public class PercentRenderer extends DefaultTableCellRenderer {

  /**
   * Template do dado que  exibido com sufixo "%".
   */
  public static final String PERCENT_FORMAT = "%d %s";

  /**
   * Sufixo que define um valor como porcentagem.
   */
  public static final String PERCENT_SUFFIX = "%";

  /**
   * Construtor padro.
   */
  public PercentRenderer() {
    super();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getTableCellRendererComponent(JTable table, Object value,
    boolean isSelected, boolean hasFocus, int row, int column) {
    super.getTableCellRendererComponent(table, value, isSelected, hasFocus,
      row, column);

    Integer valueInt = (Integer) value;

    if (valueInt >= 0) {
      setText(String.format(PERCENT_FORMAT, valueInt, PERCENT_SUFFIX));
    }
    else {
      setText(AbstractConfigurableColumn.NO_VALUE);
    }

    return this;
  }
}
