/*
 * DesktopErrorEvent.java
 * $Author: cassino $
 * $Revision: 33587 $  - $Date: 2004-04-15 11:21:24 -0300 (Thu, 15 Apr 2004) $
 */
package csbase.client.desktop;

import javax.swing.JComponent;
import javax.swing.JLabel;

/**
 * A classe <code>DesktopErrorEvent</code> representa um erro a ser sinalizado
 * em uma janela do websintesi. Contm a mensagem de erro a ser exibida na
 * linha de status da janela, o elemento (JLabel) sinalizador do campo de
 * entrada que provocou o  erro (se for o caso), e o conjunto de elementos da
 * janela afetados, isto , os elementos que devero ser desabilitados.
 *
 * @author Ana
 * @version $Revision: 33587 $
 */
public class DesktopErrorEvent {
  /** A mensagem de erro. */
  public String errorMessage;
  /** O elemento sinalizador. */
  public JLabel signaller;
  /** O conjunto de componentes afetados. */
  public JComponent[] disabledComponents;

  /**
   * Cria uma estrutura que representa um erro a ser sinalizado na janela.
   *
   * @param errorMessage mensagem de erro
   * @param signaller elemento sinalizador (ou null, se no aplicvel)
   * @param disabledComponents conjunto de elementos afetados (ou null)
   */
  public DesktopErrorEvent(
    String errorMessage, JLabel signaller, JComponent[] disabledComponents) {
    this.errorMessage = errorMessage;
    this.signaller = signaller;
    this.disabledComponents = disabledComponents;
  }
}
