package csbase.client.desktop;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

import javax.swing.JPanel;
import javax.swing.JRootPane;

/**
 * Painel de vidro.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class GlassPane extends JPanel {

  /**
   * Construtor padro.
   */
  public GlassPane() {
    super();
    setOpaque(false);
  }

  /**
   * Mtodo disponibilizado para que as classes que estendem GlassPane possam
   * utilizar o mtodo paintComponent(Graphics g) de JComponent invs do
   * paintComponent desta classe.
   * 
   * Nesta implementao, o retorno  sempre {@code True}.
   * 
   * @return {@code True}, se o GlassPane deve ser desenhado de forma a ter
   *         aparncia semi-transparente. {@code False}, se o GlassPane deve ser
   *         desenhado por JComponent.paintComponent(Graphics g), para que o
   *         GlassPane seja 100% transparente.
   */
  protected boolean shouldPaint() {
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void paintComponent(Graphics g) {
    if (shouldPaint()) {
      Graphics2D g2d = (Graphics2D) g;
      float alpha = 1f;
      int type = AlphaComposite.SRC_OVER;
      AlphaComposite composite = AlphaComposite.getInstance(type, alpha);
      g2d.setComposite(composite);
      g2d.setColor(new Color(235, 235, 235, 150));
      JRootPane rootPane = getRootPane();
      int width = rootPane.getWidth();
      int height = rootPane.getHeight();
      g2d.fill(new Rectangle2D.Double(0, 0, width, height));
    }
    else {
      /*
       * no devemos dar tratamento especial
       */
      super.paintComponent(g);
    }
  }
}
