package csbase.client.desktop;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GUIUtils;
import csbase.client.remote.srvproxies.DiskUsageProxy;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import csbase.logic.diskusageservice.DiskOccupation;

/**
 * Dilogo de about do sistema.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ProjectInfoDialog extends DesktopComponentDialog {

  /**
   * Texto com o nome do projeto
   */
  final private JTextField nameText = new JTextField(15);

  /**
   * Texto com a descrio.
   */
  final private JTextField descriptionText = new JTextField(15);

  /**
   * Texto com o id do usurio
   */
  final private JTextField userText = new JTextField(15);

  /**
   * Texto com o nome do usurio
   */
  final private JTextField userNameText = new JTextField(20);

  /**
   * Nome do servidor que criou o projeto
   */
  final private JTextField serverOwnerText = new JTextField(15);

  /**
   * Texto com o espao ocupado.
   */
  final private JTextField usageText = new JTextField(15);

  /**
   * Texto com o espao livre.
   */
  final private JTextField freeText = new JTextField(15);

  /**
   * Busca de string de internacionalizao.
   * 
   * @param tag o tag para a classe
   * @return o texto
   */
  final private String getString(final String tag) {
    final String className = this.getClass().getSimpleName();
    return LNG.get(className + "." + tag);
  }

  /**
   * Cria o painel de botes.
   * 
   * @return painel
   */
  protected JPanel buildMainPanel() {
    final JLabel nameLabel = new JLabel(getString("name.label"));
    final JLabel descriptionLabel = new JLabel(getString("description.label"));
    final JLabel usageLabel = new JLabel(getString("usage.label"));
    final JLabel freeLabel = new JLabel(getString("free.label"));
    final JLabel userLabel = new JLabel(getString("user.label"));
    final JLabel userNameLabel = new JLabel(getString("user.name.label"));
    final JLabel serverOwnerLabel = new JLabel(getString("server.owner.label"));

    userText.setEditable(false);
    nameText.setEditable(false);
    descriptionText.setEditable(false);
    usageText.setEditable(false);
    freeText.setEditable(false);
    userNameText.setEditable(false);
    serverOwnerText.setEditable(false);

    usageText.setHorizontalAlignment(JTextField.RIGHT);
    freeText.setHorizontalAlignment(JTextField.RIGHT);

    final JComponent[][] cmps =
      new JComponent[][] { { nameLabel, nameText },
          { descriptionLabel, descriptionText }, { userLabel, userText },
          { userNameLabel, userNameText },
          { serverOwnerLabel, serverOwnerText }, { new JLabel(" ") },
          { usageLabel, usageText }, { freeLabel, freeText }, };
    final JPanel panel = GUIUtils.createBasicGridPanel(cmps);
    return panel;
  }

  /**
   * Cria o painel de botes.
   * 
   * @return painel
   */
  protected JPanel buildButtonsPanel() {
    final JPanel panel = new JPanel(new FlowLayout());

    final JButton closeButton = new JButton(getString("close.button"));
    closeButton.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent ev) {
        close();
      }
    });

    final JButton refreshButton = new JButton(getString("refresh.button"));
    refreshButton.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent ev) {
        refresh();
      }
    });

    panel.add(refreshButton);
    panel.add(closeButton);
    GUIUtils
      .matchPreferredSizes(new JComponent[] { refreshButton, closeButton });

    return panel;
  }

  /**
   * Atualizao dos dados.
   */
  final public void refresh() {
    final DesktopFrame desktopFrame = DesktopFrame.getInstance();
    final CommonClientProject prj = desktopFrame.getProject();
    final String projName = prj.getName();
    final Object ownerId = prj.getUserId();

    nameText.setText(projName);
    descriptionText.setText(prj.getDescription());
    userText.setText(ownerId.toString());

    RemoteTask<String> task = new RemoteTask<String>() {
      @Override
      protected void performTask() throws Exception {
        setResult(User.getName(ownerId));
      }
    };
    if (task.execute(desktopFrame.getDesktopFrame(), getTitle(),
      getString("get.user.name.msg"))) {
      userNameText.setText(task.getResult());
    }

    serverOwnerText.setText(prj.getOwnerServerName());

    final DiskOccupation occ = DiskUsageProxy.getCurrentProjectOccupation();
    if (!occ.isValid()) {
      usageText.setText("?");
      freeText.setText("?");
      return;
    }

    final double freeMb = occ.getFreeSpaceMb();
    final double usedMb = occ.getUsedSpaceMb();

    final String usageStr = getText(usedMb);
    final String freeStr = getText(freeMb);
    usageText.setText(usageStr);
    freeText.setText(freeStr);
  }

  /**
   * Monta texto de uso com base em espao (mb)
   * 
   * @param spaceMb espao
   * @return texto
   */
  private String getText(double spaceMb) {
    double value = spaceMb;
    String unit = "mb";
    if (value > 1024) {
      value = value / 1024;
      unit = "gb";
      if (value > 1024) {
        value = value / 1024;
        unit = "tb";
      }
    }

    final DecimalFormat formatter = new DecimalFormat("0.00");
    final String text = formatter.format(value) + " " + unit;
    return text;
  }

  /**
   * Construtor
   * 
   * @param desktopFrame o desktop do sistema.
   */
  public ProjectInfoDialog(final DesktopFrame desktopFrame) {
    super(desktopFrame.getDesktopFrame());

    setTitle(getString("title"));
    final JPanel mainPanel = new JPanel();
    mainPanel.setLayout(new BorderLayout());
    mainPanel.add(buildMainPanel(), BorderLayout.CENTER);
    mainPanel.add(buildButtonsPanel(), BorderLayout.SOUTH);
    final Container container = this.getContentPane();
    container.add(mainPanel);
    pack();
    setResizable(false);
  }
}
