/*
 * $Id$
 */
package csbase.client.facilities.algorithms.executor;

import java.awt.Window;
import java.rmi.RemoteException;

import csbase.client.facilities.algorithms.parameters.NodeParametersValues;
import csbase.exception.OperationFailureException;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.Priority;

/**
 * Executor programtico de comandos do tipo algoritmo simples.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class AlgorithmCommandExecutor extends AbstractCommandExecutor {

  /**
   * Executa um algoritmo, dado o nome e identificador da verso, configurando-o
   * com os valores de parmetros especificados.
   * 
   * @param paramValues valores dos parmetros do algoritmo a serem preenchidos
   * @param description descrio do comando
   * @param sgaServerName nome do servidor do SGA a ser usado para execuo. Se
   *        for null, indica que a seleo do servidor ser automtica.
   * @param owner janela-me da ao.
   * @param observers Observadores remotos do comando executado
   * 
   * @return retorna true, se o comando foi executado com sucesso, caso
   *         contrrio, retorna false
   * @throws RemoteException caso tenha havido falha na chamada remota
   * @throws OperationFailureException caso o escalonador de comandos no esteja
   *         inicializado
   */
  public String executeCommand(NodeParametersValues paramValues,
    String description, String sgaServerName, Window owner,
    CommandObserver... observers) throws RemoteException,
    OperationFailureException {

    CommandConfiguration commandConfig =
      new CommandConfiguration(paramValues.getAlgorithmName(), paramValues
        .getAlgorithmVersionId(), owner);
    if (!commandConfig.config(paramValues)) {
      return null;
    }

    return executeCommand(commandConfig.getConfigurator(), description,
      sgaServerName, owner, observers);
  }

  /**
   * Executa um algoritmo a partir do seu configurador devidamente preenchido.
   * 
   * @param configurator configurador do algoritmo, que j possui os parmetros
   *        inicializados
   * @param description descrio do comando
   * @param sgaServerName nome do servidor do SGA a ser usado para execuo. Se
   *        for null, indica que a seleo do servidor ser automtica.
   * @param observers Observadores remotos do comando executado
   * 
   * @return retorna true, se o comando foi executado com sucesso, caso
   *         contrrio, retorna false
   * @throws RemoteException caso tenha havido falha na chamada remota
   * @throws OperationFailureException caso o escalonador de comandos no esteja
   *         inicializado
   */
  @Override
  public String executeCommand(AlgorithmConfigurator configurator,
    String description, String sgaServerName, Window owner,
    CommandObserver... observers) throws RemoteException,
    OperationFailureException {
    return executeCommand(configurator, description, sgaServerName,
      Priority.ROOT, owner, observers);
  }

  /**
   * Executa um algoritmo a partir do seu configurador devidamente preenchido.
   * 
   * @param configurator configurador do algoritmo, que j possui os parmetros
   *        inicializados
   * @param description descrio do comando
   * @param sgaServerName nome do servidor do SGA a ser usado para execuo. Se
   *        for null, indica que a seleo do servidor ser automtica.
   * @param priority indica a prioridade do comando a ser executado.
   * @param observers Observadores remotos do comando executado
   * 
   * @return retorna true, se o comando foi executado com sucesso, caso
   *         contrrio, retorna false
   * @throws RemoteException caso tenha havido falha na chamada remota
   * @throws OperationFailureException caso o escalonador de comandos no esteja
   *         inicializado
   */
  @Override
  public String executeCommand(AlgorithmConfigurator configurator,
    String description, String sgaServerName, Priority priority, Window owner,
    CommandObserver... observers) throws RemoteException,
    OperationFailureException {
    return super.executeCommand(configurator, description, sgaServerName,
      priority, owner, observers);
  }

}
